/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

@Incubating(since="7.36.0")
public final class InstanceOfPatternMatch
extends Recipe {
    public String getDisplayName() {
        return "Changes code to use Java 17's `instanceof` pattern matching";
    }

    public String getDescription() {
        return "Adds pattern variables to `instanceof` expressions wherever the same (side effect free) expression is referenced in a corresponding type cast expression within the flow scope of the `instanceof`. Currently, this recipe supports `if` statements and ternary operator expressions.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), Preconditions.not(new KotlinFileChecker()), Preconditions.not(new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            @Nullable
            public J postVisit(J tree, ExecutionContext executionContext) {
                J result = (J)super.postVisit((Tree)tree, (Object)executionContext);
                InstanceOfPatternReplacements original = (InstanceOfPatternReplacements)this.getCursor().getMessage("flowTypeScope");
                if (original != null && !original.isEmpty()) {
                    return UseInstanceOfPatternMatching.refactor(result, original, this.getCursor().getParentOrThrow());
                }
                return result;
            }

            public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, ExecutionContext ctx) {
                if ((instanceOf = (J.InstanceOf)super.visitInstanceOf(instanceOf, (Object)ctx)).getPattern() != null || !instanceOf.getSideEffects().isEmpty()) {
                    return instanceOf;
                }
                Cursor maybeReplacementRoot = null;
                J.Binary additionalContext = null;
                boolean flowScopeBreakEncountered = false;
                Iterator it = this.getCursor().getPathAsCursors();
                while (it.hasNext()) {
                    Cursor next = (Cursor)it.next();
                    Object value = next.getValue();
                    if (value instanceof J.Binary) {
                        J.Binary binary = (J.Binary)value;
                        if (!flowScopeBreakEncountered && binary.getOperator() == J.Binary.Type.And) {
                            additionalContext = binary;
                            continue;
                        }
                        flowScopeBreakEncountered = true;
                        continue;
                    }
                    if (value instanceof J.Unary && ((J.Unary)value).getOperator() == J.Unary.Type.Not) {
                        flowScopeBreakEncountered = true;
                        continue;
                    }
                    if (!(value instanceof Statement)) continue;
                    maybeReplacementRoot = next;
                    break;
                }
                if (maybeReplacementRoot != null) {
                    J root = (J)maybeReplacementRoot.getValue();
                    HashSet<J> contexts = new HashSet<J>();
                    if (!flowScopeBreakEncountered) {
                        if (root instanceof J.If) {
                            contexts.add((J)((J.If)root).getThenPart());
                        } else if (root instanceof J.Ternary) {
                            contexts.add((J)((J.Ternary)root).getTruePart());
                        }
                    }
                    if (additionalContext != null) {
                        contexts.add((J)additionalContext);
                    }
                    if (!contexts.isEmpty()) {
                        InstanceOfPatternReplacements replacements = (InstanceOfPatternReplacements)maybeReplacementRoot.computeMessageIfAbsent("flowTypeScope", k -> new InstanceOfPatternReplacements(root));
                        replacements.registerInstanceOf(instanceOf, contexts);
                    }
                }
                return instanceOf;
            }

            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                InstanceOfPatternReplacements replacements;
                J result = super.visitTypeCast(typeCast, (Object)ctx);
                if (result instanceof J.TypeCast && (replacements = (InstanceOfPatternReplacements)this.getCursor().getNearestMessage("flowTypeScope")) != null) {
                    replacements.registerTypeCast((J.TypeCast)result, this.getCursor());
                }
                return result;
            }
        });
    }

    @Nullable
    private static JavaType toJavaType(TypedTree typeTree) {
        if (typeTree instanceof J.ArrayType) {
            JavaType.Array result = new JavaType.Array(null, ((J.ArrayType)typeTree).getElementType().getType());
            for (int i = 0; i < ((J.ArrayType)typeTree).getDimensions().size() - 1; ++i) {
                result = new JavaType.Array(null, (JavaType)result);
            }
            return result;
        }
        return typeTree.getType();
    }

    private static String variableBaseName(TypeTree typeTree, VariableNameStrategy nameStrategy) {
        return nameStrategy.variableName(InstanceOfPatternMatch.toJavaType((TypedTree)typeTree));
    }

    public String toString() {
        return "InstanceOfPatternMatch()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceOfPatternMatch)) {
            return false;
        }
        InstanceOfPatternMatch other = (InstanceOfPatternMatch)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstanceOfPatternMatch;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static class VariableNameStrategy {
        public static final Pattern NAME_SPLIT_PATTERN = Pattern.compile("[$._]*(?=\\p{Upper}+[\\p{Lower}\\p{Digit}]*)");
        private final Style style;
        @Nullable
        private final String name;
        private final Set<Cursor> contextScopes;

        private VariableNameStrategy(Style style, @Nullable String exactName, Set<Cursor> contextScopes) {
            this.style = style;
            this.name = exactName;
            this.contextScopes = contextScopes;
        }

        static VariableNameStrategy short_() {
            return new VariableNameStrategy(Style.SHORT, null, Collections.emptySet());
        }

        static VariableNameStrategy normal(Set<Cursor> contextScopes) {
            return new VariableNameStrategy(Style.NORMAL, null, contextScopes);
        }

        static VariableNameStrategy exact(String name) {
            return new VariableNameStrategy(Style.EXACT, name, Collections.emptySet());
        }

        public String variableName(@Nullable JavaType type) {
            if (this.style == Style.EXACT) {
                return this.name;
            }
            if (type instanceof JavaType.FullyQualified) {
                String className = ((JavaType.FullyQualified)type).getClassName();
                if (className.indexOf(46) > 0) {
                    className = className.substring(className.lastIndexOf(46));
                }
                String baseName = null;
                switch (this.style) {
                    case SHORT: {
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < className.length(); ++i) {
                            char c2 = className.charAt(i);
                            if (!Character.isUpperCase(c2)) continue;
                            builder.append(Character.toLowerCase(c2));
                        }
                        baseName = builder.length() > 0 ? builder.toString() : "o";
                        break;
                    }
                    case NORMAL: {
                        Set namesInScope = this.contextScopes.stream().flatMap(c -> VariableNameUtils.findNamesInScope((Cursor)c).stream()).collect(Collectors.toSet());
                        List nameSegments = Stream.of(NAME_SPLIT_PATTERN.split(className)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                        for (int i = nameSegments.size() - 1; i >= 0; --i) {
                            String name = String.join((CharSequence)"", nameSegments.subList(i, nameSegments.size()));
                            if (name.length() < 2 || namesInScope.contains(name = Character.toLowerCase(name.charAt(0)) + name.substring(1))) continue;
                            baseName = name;
                            break;
                        }
                        if (baseName != null) break;
                        baseName = Character.toLowerCase(className.charAt(0)) + className.substring(1);
                        break;
                    }
                    default: {
                        baseName = "obj";
                    }
                }
                String candidate = baseName;
                block6: while (true) {
                    for (Cursor scope : this.contextScopes) {
                        String newCandidate = VariableNameUtils.generateVariableName((String)candidate, (Cursor)scope, (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                        if (newCandidate.equals(candidate)) continue;
                        candidate = newCandidate;
                        continue block6;
                    }
                    break;
                }
                return candidate;
            }
            if (type instanceof JavaType.Primitive) {
                String keyword = ((JavaType.Primitive)type).getKeyword();
                return this.style == Style.SHORT ? keyword.substring(0, 1) : keyword;
            }
            if (type instanceof JavaType.Array) {
                JavaType elemType = ((JavaType.Array)type).getElemType();
                while (elemType instanceof JavaType.Array) {
                    elemType = ((JavaType.Array)elemType).getElemType();
                }
                return this.variableName(elemType) + 's';
            }
            return this.style == Style.SHORT ? "o" : "obj";
        }

        static enum Style {
            SHORT,
            NORMAL,
            EXACT;

        }
    }

    private static class UseInstanceOfPatternMatching
    extends JavaVisitor<Integer> {
        private final InstanceOfPatternReplacements replacements;

        public UseInstanceOfPatternMatching(InstanceOfPatternReplacements replacements) {
            this.replacements = replacements;
        }

        @Nullable
        static J refactor(@Nullable J tree, InstanceOfPatternReplacements replacements, Cursor cursor) {
            return (J)new UseInstanceOfPatternMatching(replacements).visit((Tree)tree, 0, cursor);
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, Integer executionContext) {
            instanceOf = (J.InstanceOf)super.visitInstanceOf(instanceOf, (Object)executionContext);
            instanceOf = this.replacements.processInstanceOf(instanceOf, this.getCursor());
            return instanceOf;
        }

        public <T extends J> J visitParentheses(J.Parentheses<T> parens, Integer executionContext) {
            J replacement;
            if (parens.getTree() instanceof J.TypeCast && (replacement = this.replacements.processTypeCast((J.TypeCast)parens.getTree(), this.getCursor())) != null) {
                return replacement;
            }
            return super.visitParentheses(parens, (Object)executionContext);
        }

        public J visitTypeCast(J.TypeCast typeCast, Integer executionContext) {
            J replacement = this.replacements.processTypeCast(typeCast = (J.TypeCast)super.visitTypeCast(typeCast, (Object)executionContext), this.getCursor());
            if (replacement != null) {
                return replacement;
            }
            return typeCast;
        }

        @Nullable
        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, Integer integer) {
            multiVariable = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)integer);
            return this.replacements.processVariableDeclarations(multiVariable);
        }
    }

    private static class InstanceOfPatternReplacements {
        private final J root;
        private final Map<ExpressionAndType, J.InstanceOf> instanceOfs = new HashMap<ExpressionAndType, J.InstanceOf>();
        private final Map<J.InstanceOf, Set<J>> contexts = new HashMap<J.InstanceOf, Set<J>>();
        private final Map<J.InstanceOf, Set<Cursor>> contextScopes = new HashMap<J.InstanceOf, Set<Cursor>>();
        private final Map<J.TypeCast, J.InstanceOf> replacements = new HashMap<J.TypeCast, J.InstanceOf>();
        private final Map<J.InstanceOf, J.VariableDeclarations.NamedVariable> variablesToDelete = new HashMap<J.InstanceOf, J.VariableDeclarations.NamedVariable>();

        public void registerInstanceOf(J.InstanceOf instanceOf, Set<J> contexts) {
            Expression expression = instanceOf.getExpression();
            JavaType type = InstanceOfPatternMatch.toJavaType((TypedTree)instanceOf.getClazz());
            Optional<ExpressionAndType> existing = this.instanceOfs.keySet().stream().filter(k -> TypeUtils.isAssignableTo((JavaType)type, (JavaType)k.getType()) && SemanticallyEqual.areEqual((J)k.getExpression(), (J)expression)).findAny();
            if (!existing.isPresent()) {
                this.instanceOfs.put(new ExpressionAndType(expression, type), instanceOf);
                this.contexts.put(instanceOf, contexts);
            }
        }

        public void registerTypeCast(J.TypeCast typeCast, Cursor cursor) {
            Expression expression = typeCast.getExpression();
            JavaType type = InstanceOfPatternMatch.toJavaType((TypedTree)typeCast.getClazz().getTree());
            Optional<ExpressionAndType> match = this.instanceOfs.keySet().stream().filter(k -> TypeUtils.isAssignableTo((JavaType)type, (JavaType)k.getType()) && SemanticallyEqual.areEqual((J)k.getExpression(), (J)expression)).findAny();
            if (match.isPresent()) {
                Cursor parent = cursor.getParentTreeCursor();
                J.InstanceOf instanceOf = this.instanceOfs.get(match.get());
                Set<J> validContexts = this.contexts.get(instanceOf);
                Iterator it = cursor.getPath();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (validContexts.contains(next)) {
                        if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable && !this.variablesToDelete.containsKey(instanceOf)) {
                            this.variablesToDelete.put(instanceOf, (J.VariableDeclarations.NamedVariable)parent.getValue());
                        } else {
                            this.replacements.put(typeCast, instanceOf);
                        }
                        this.contextScopes.computeIfAbsent(instanceOf, k -> new HashSet()).add(cursor);
                        break;
                    }
                    if (this.root != next) continue;
                    break;
                }
            }
        }

        public boolean isEmpty() {
            return this.replacements.isEmpty() && this.variablesToDelete.isEmpty();
        }

        public J.InstanceOf processInstanceOf(J.InstanceOf instanceOf, Cursor cursor) {
            if (!this.contextScopes.containsKey(instanceOf)) {
                return instanceOf;
            }
            @Nullable JavaType type = InstanceOfPatternMatch.toJavaType((TypedTree)((TypeTree)instanceOf.getClazz()));
            String name = this.patternVariableName(instanceOf, cursor);
            J.InstanceOf result = instanceOf.withPattern((J)new J.Identifier(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, Collections.emptyList(), name, type, null));
            for (Map.Entry<J.TypeCast, J.InstanceOf> entry : this.replacements.entrySet()) {
                if (entry.getValue() != instanceOf) continue;
                entry.setValue(result);
            }
            return result;
        }

        private String patternVariableName(J.InstanceOf instanceOf, Cursor cursor) {
            J.VariableDeclarations.NamedVariable variable;
            VariableNameStrategy strategy = this.root instanceof J.If ? ((variable = this.variablesToDelete.get(instanceOf)) != null ? VariableNameStrategy.exact(variable.getSimpleName()) : VariableNameStrategy.normal(this.contextScopes.get(instanceOf))) : VariableNameStrategy.short_();
            String baseName = InstanceOfPatternMatch.variableBaseName((TypeTree)instanceOf.getClazz(), strategy);
            return VariableNameUtils.generateVariableName((String)baseName, (Cursor)cursor, (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
        }

        @Nullable
        public J processTypeCast(J.TypeCast typeCast, Cursor cursor) {
            J.InstanceOf instanceOf = this.replacements.get(typeCast);
            if (instanceOf != null && instanceOf.getPattern() != null) {
                String name = ((J.Identifier)instanceOf.getPattern()).getSimpleName();
                TypedTree owner = (TypedTree)cursor.firstEnclosing(J.MethodDeclaration.class);
                owner = owner != null ? owner : (TypedTree)cursor.firstEnclosingOrThrow(J.ClassDeclaration.class);
                JavaType.Variable fieldType = new JavaType.Variable(null, Flag.Default.getBitMask(), name, owner.getType(), typeCast.getType(), Collections.emptyList());
                return new J.Identifier(Tree.randomId(), typeCast.getPrefix(), Markers.EMPTY, Collections.emptyList(), name, typeCast.getType(), fieldType);
            }
            return null;
        }

        @Nullable
        public J processVariableDeclarations(J.VariableDeclarations multiVariable) {
            return multiVariable.getVariables().stream().anyMatch(this.variablesToDelete::containsValue) ? null : multiVariable;
        }

        public InstanceOfPatternReplacements(J root) {
            this.root = root;
        }

        public J getRoot() {
            return this.root;
        }

        public Map<ExpressionAndType, J.InstanceOf> getInstanceOfs() {
            return this.instanceOfs;
        }

        public Map<J.InstanceOf, Set<J>> getContexts() {
            return this.contexts;
        }

        public Map<J.InstanceOf, Set<Cursor>> getContextScopes() {
            return this.contextScopes;
        }

        public Map<J.TypeCast, J.InstanceOf> getReplacements() {
            return this.replacements;
        }

        public Map<J.InstanceOf, J.VariableDeclarations.NamedVariable> getVariablesToDelete() {
            return this.variablesToDelete;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOfPatternReplacements)) {
                return false;
            }
            InstanceOfPatternReplacements other = (InstanceOfPatternReplacements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            J this$root = this.getRoot();
            J other$root = other.getRoot();
            if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
                return false;
            }
            Map<ExpressionAndType, J.InstanceOf> this$instanceOfs = this.getInstanceOfs();
            Map<ExpressionAndType, J.InstanceOf> other$instanceOfs = other.getInstanceOfs();
            if (this$instanceOfs == null ? other$instanceOfs != null : !((Object)this$instanceOfs).equals(other$instanceOfs)) {
                return false;
            }
            Map<J.InstanceOf, Set<J>> this$contexts = this.getContexts();
            Map<J.InstanceOf, Set<J>> other$contexts = other.getContexts();
            if (this$contexts == null ? other$contexts != null : !((Object)this$contexts).equals(other$contexts)) {
                return false;
            }
            Map<J.InstanceOf, Set<Cursor>> this$contextScopes = this.getContextScopes();
            Map<J.InstanceOf, Set<Cursor>> other$contextScopes = other.getContextScopes();
            if (this$contextScopes == null ? other$contextScopes != null : !((Object)this$contextScopes).equals(other$contextScopes)) {
                return false;
            }
            Map<J.TypeCast, J.InstanceOf> this$replacements = this.getReplacements();
            Map<J.TypeCast, J.InstanceOf> other$replacements = other.getReplacements();
            if (this$replacements == null ? other$replacements != null : !((Object)this$replacements).equals(other$replacements)) {
                return false;
            }
            Map<J.InstanceOf, J.VariableDeclarations.NamedVariable> this$variablesToDelete = this.getVariablesToDelete();
            Map<J.InstanceOf, J.VariableDeclarations.NamedVariable> other$variablesToDelete = other.getVariablesToDelete();
            return !(this$variablesToDelete == null ? other$variablesToDelete != null : !((Object)this$variablesToDelete).equals(other$variablesToDelete));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceOfPatternReplacements;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : $root.hashCode());
            Map<ExpressionAndType, J.InstanceOf> $instanceOfs = this.getInstanceOfs();
            result = result * 59 + ($instanceOfs == null ? 43 : ((Object)$instanceOfs).hashCode());
            Map<J.InstanceOf, Set<J>> $contexts = this.getContexts();
            result = result * 59 + ($contexts == null ? 43 : ((Object)$contexts).hashCode());
            Map<J.InstanceOf, Set<Cursor>> $contextScopes = this.getContextScopes();
            result = result * 59 + ($contextScopes == null ? 43 : ((Object)$contextScopes).hashCode());
            Map<J.TypeCast, J.InstanceOf> $replacements = this.getReplacements();
            result = result * 59 + ($replacements == null ? 43 : ((Object)$replacements).hashCode());
            Map<J.InstanceOf, J.VariableDeclarations.NamedVariable> $variablesToDelete = this.getVariablesToDelete();
            result = result * 59 + ($variablesToDelete == null ? 43 : ((Object)$variablesToDelete).hashCode());
            return result;
        }

        public String toString() {
            return "InstanceOfPatternMatch.InstanceOfPatternReplacements(root=" + this.getRoot() + ", instanceOfs=" + this.getInstanceOfs() + ", contexts=" + this.getContexts() + ", contextScopes=" + this.getContextScopes() + ", replacements=" + this.getReplacements() + ", variablesToDelete=" + this.getVariablesToDelete() + ")";
        }
    }

    private static class ExpressionAndType {
        private final Expression expression;
        private final JavaType type;

        public ExpressionAndType(Expression expression, JavaType type) {
            this.expression = expression;
            this.type = type;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public JavaType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionAndType)) {
                return false;
            }
            ExpressionAndType other = (ExpressionAndType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExpressionAndType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "InstanceOfPatternMatch.ExpressionAndType(expression=" + this.getExpression() + ", type=" + this.getType() + ")";
        }
    }
}

