/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.nodejs.search;

import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.nodejs.Dependency;
import org.openrewrite.nodejs.NodeResolutionResult;
import org.openrewrite.nodejs.search.IsPackageJson;
import org.openrewrite.nodejs.search.IsPackageLockJson;
import org.openrewrite.nodejs.table.DependenciesInUse;
import org.openrewrite.semver.Semver;

public final class DependencyInsight
extends ScanningRecipe<AtomicReference<NodeResolutionResult>> {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    @Option(displayName="Name pattern", description="Name glob pattern used to match dependencies.", example="@apollo*")
    private final String namePattern;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Only direct", description="If enabled, transitive dependencies will not be considered. All dependencies are searched by default.", required=false, example="true")
    private final @Nullable Boolean onlyDirect;

    public String getDisplayName() {
        return "Node.js dependency insight";
    }

    public String getDescription() {
        return "Identify the direct and transitive Node.js dependencies used in a project.";
    }

    public Validated<Object> validate() {
        Validated v = super.validate();
        if (this.version != null) {
            v = v.and(Semver.validate((String)this.version, null));
        }
        return v;
    }

    public AtomicReference<NodeResolutionResult> getInitialValue(ExecutionContext ctx) {
        return new AtomicReference<NodeResolutionResult>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicReference<NodeResolutionResult> resolution) {
        return Preconditions.check(new IsPackageLockJson(), (TreeVisitor)new JsonIsoVisitor<ExecutionContext>(){

            public Json.Document visitDocument(Json.Document document, ExecutionContext ctx) {
                resolution.set(NodeResolutionResult.fromPackageLockJson(document));
                return document;
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicReference<NodeResolutionResult> resolution) {
        final JsonPathMatcher dependency = new JsonPathMatcher("$.dependencies");
        final JsonPathMatcher devDependencies = new JsonPathMatcher("$.devDependencies");
        return Preconditions.check(new IsPackageJson(), (TreeVisitor)new JsonVisitor<ExecutionContext>(){

            public Json visitMember(Json.Member member, ExecutionContext ctx) {
                String name;
                Json m = super.visitMember(member, (Object)ctx);
                Cursor maybeDependencies = this.getCursor().getParent(2);
                if (maybeDependencies != null && (dependency.matches(maybeDependencies) || devDependencies.matches(maybeDependencies)) && StringUtils.matchesGlob((String)(name = ((Json.Literal)member.getKey()).getValue().toString()), (String)DependencyInsight.this.namePattern)) {
                    String requestedVersion = ((Json.Literal)member.getValue()).getValue().toString();
                    Dependency dependency2 = resolution.get() == null ? null : ((NodeResolutionResult)resolution.get()).getDependency(name);
                    String resolvedVersion = dependency2 == null || dependency2.getResolved() == null ? "" : dependency2.getResolved().getVersion();
                    DependencyInsight.this.dependenciesInUse.insertRow(ctx, new DependenciesInUse.Row(name, requestedVersion, resolvedVersion));
                    m = (Json)SearchResult.found((Tree)m, (String)resolvedVersion);
                }
                return m;
            }
        });
    }

    @ConstructorProperties(value={"namePattern", "version", "onlyDirect"})
    @Generated
    public DependencyInsight(String namePattern, @Nullable String version, @Nullable Boolean onlyDirect) {
        this.namePattern = namePattern;
        this.version = version;
        this.onlyDirect = onlyDirect;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public String getNamePattern() {
        return this.namePattern;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + (Object)((Object)this.getDependenciesInUse()) + ", namePattern=" + this.getNamePattern() + ", version=" + this.getVersion() + ", onlyDirect=" + this.getOnlyDirect() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$namePattern = this.getNamePattern();
        String other$namePattern = other.getNamePattern();
        if (this$namePattern == null ? other$namePattern != null : !this$namePattern.equals(other$namePattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $namePattern = this.getNamePattern();
        result = result * 59 + ($namePattern == null ? 43 : $namePattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

