/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.nodejs;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.nodejs.Dependency;
import org.openrewrite.nodejs.NodeResolutionResult;
import org.openrewrite.nodejs.UpgradeDependencyVersion;
import org.openrewrite.nodejs.Vulnerability;
import org.openrewrite.nodejs.internal.StaticVersionComparator;
import org.openrewrite.nodejs.internal.Version;
import org.openrewrite.nodejs.internal.VersionParser;
import org.openrewrite.nodejs.search.IsPackageJson;
import org.openrewrite.nodejs.search.IsPackageLockJson;
import org.openrewrite.nodejs.table.VulnerabilityReport;
import org.openrewrite.semver.LatestPatch;

public final class DependencyVulnerabilityCheck
extends ScanningRecipe<Accumulator> {
    private final transient VersionParser versionParser = new VersionParser();
    private final transient VulnerabilityReport report = new VulnerabilityReport((Recipe)this);
    @Option(displayName="Add search markers", description="Report each vulnerability as search result markers. When enabled you can see which dependencies are bringing in vulnerable transitives in the diff view. By default these markers are omitted, making it easier to see version upgrades within the diff.", required=false)
    private final @Nullable Boolean addMarkers;

    public String getDisplayName() {
        return "Find and fix vulnerable npm dependencies";
    }

    public String getDescription() {
        return "This software composition analysis (SCA) tool detects and upgrades dependencies with publicly disclosed vulnerabilities. This recipe both generates a report of vulnerable dependencies and upgrades to newer versions with fixes. This recipe **only** upgrades to the latest **patch** version.  If a minor or major upgrade is required to reach the fixed version, this recipe will not make any changes. Vulnerability information comes from the [GitHub Security Advisory Database](https://docs.github.com/en/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database), which aggregates vulnerability data from several public databases, including the [National Vulnerability Database](https://nvd.nist.gov/) maintained by the United States government. Dependencies following [Semantic Versioning](https://semver.org/) will see their _patch_ version updated where applicable.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        CsvMapper csvMapper = new CsvMapper();
        csvMapper.registerModule((Module)new JavaTimeModule());
        HashMap<String, List<Vulnerability>> db = new HashMap<String, List<Vulnerability>>();
        try (InputStream resourceAsStream = DependencyVulnerabilityCheck.class.getResourceAsStream("/advisories-npm.csv");
             MappingIterator vs = csvMapper.readerWithSchemaFor(Vulnerability.class).readValues(resourceAsStream);){
            while (vs.hasNextValue()) {
                Vulnerability v = (Vulnerability)vs.nextValue();
                db.computeIfAbsent(v.getPackageName(), g -> new ArrayList()).add(v);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Accumulator(db, new HashMap<Accumulator.NameVersion, Set<Vulnerability>>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return Preconditions.check(new IsPackageLockJson(), (TreeVisitor)new JsonIsoVisitor<ExecutionContext>(){

            public Json.Document visitDocument(Json.Document document, ExecutionContext ctx) {
                NodeResolutionResult nodeResolutionResult = NodeResolutionResult.fromPackageLockJson(document);
                this.findVulnerabilities(nodeResolutionResult.getDependencies());
                this.findVulnerabilities(nodeResolutionResult.getDevDependencies());
                return document;
            }

            private void findVulnerabilities(Collection<Dependency> dependencies) {
                for (Dependency dependency : dependencies) {
                    for (Vulnerability v : acc.getDb().getOrDefault(dependency.getName(), Collections.emptyList())) {
                        String resolvedVersion = dependency.getResolved() == null ? null : dependency.getResolved().getVersion();
                        acc.getVulnerabilities().computeIfAbsent(new Accumulator.NameVersion(dependency.getName(), resolvedVersion), nv -> new LinkedHashSet()).add(v);
                    }
                }
            }
        });
    }

    public Collection<SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        StaticVersionComparator vc = new StaticVersionComparator();
        LatestPatch latestPatch = new LatestPatch(null);
        for (Map.Entry<Accumulator.NameVersion, Set<Vulnerability>> vulnerabilitiesByPackage : acc.getVulnerabilities().entrySet()) {
            Accumulator.NameVersion nameVersion = vulnerabilitiesByPackage.getKey();
            Version resolvedVersion = this.versionParser.transform(nameVersion.getVersion());
            for (Vulnerability v : vulnerabilitiesByPackage.getValue()) {
                if (vc.compare(resolvedVersion, this.versionParser.transform(v.getFixedVersion())) >= 0) continue;
                boolean fixWithPatchVersionUpdateOnly = latestPatch.isValid(nameVersion.getVersion(), v.getFixedVersion()) && latestPatch.compare(nameVersion.getVersion(), nameVersion.getVersion(), v.getFixedVersion()) < 0;
                this.report.insertRow(ctx, new VulnerabilityReport.Row(v.getCve(), nameVersion.getName(), nameVersion.getVersion(), v.getFixedVersion(), v.getLastAffectedVersion(), fixWithPatchVersionUpdateOnly, v.getSummary(), v.getSeverity().toString(), 0, v.getCwes()));
            }
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        final JsonPathMatcher dependency = new JsonPathMatcher("$.dependencies");
        final JsonPathMatcher devDependencies = new JsonPathMatcher("$.devDependencies");
        final StaticVersionComparator vc = new StaticVersionComparator();
        final LatestPatch latestPatch = new LatestPatch(null);
        return Preconditions.check(new IsPackageJson(), (TreeVisitor)new JsonIsoVisitor<ExecutionContext>(){

            public Json.Document visitDocument(Json.Document document, ExecutionContext ctx) {
                Json.Document d = super.visitDocument(document, (Object)ctx);
                for (Map.Entry<Accumulator.NameVersion, Set<Vulnerability>> entry : acc.getVulnerabilities().entrySet()) {
                    String resolvedVersion = entry.getKey().getVersion();
                    for (Vulnerability v : entry.getValue()) {
                        boolean fixWithPatchVersionUpdateOnly = latestPatch.isValid(resolvedVersion, v.getFixedVersion()) && latestPatch.compare(resolvedVersion, resolvedVersion, v.getFixedVersion()) < 0;
                        if (!fixWithPatchVersionUpdateOnly) continue;
                        d = (Json.Document)new UpgradeDependencyVersion(v.getPackageName(), '^' + v.getFixedVersion()).getVisitor().visitNonNull((Tree)d, (Object)ctx, this.getCursor().getParentOrThrow());
                    }
                }
                return d;
            }

            public Json.Member visitMember(Json.Member member, ExecutionContext ctx) {
                Json.Member m = super.visitMember(member, (Object)ctx);
                if (!Boolean.TRUE.equals(DependencyVulnerabilityCheck.this.addMarkers)) {
                    return m;
                }
                Cursor maybeDependencies = this.getCursor().getParent(2);
                if (maybeDependencies != null && (dependency.matches(maybeDependencies) || devDependencies.matches(maybeDependencies))) {
                    String name = ((Json.Literal)member.getKey()).getValue().toString();
                    for (Map.Entry<Accumulator.NameVersion, Set<Vulnerability>> entry : acc.getVulnerabilities().entrySet()) {
                        Accumulator.NameVersion nameVersion = entry.getKey();
                        if (!nameVersion.getName().equals(name)) continue;
                        Version resolvedVersion = DependencyVulnerabilityCheck.this.versionParser.transform(nameVersion.getVersion());
                        List applicableVulnerabilities = entry.getValue().stream().filter(v -> StringUtils.isBlank((String)v.getFixedVersion()) || vc.compare(resolvedVersion, DependencyVulnerabilityCheck.this.versionParser.transform(v.getFixedVersion())) < 0).collect(Collectors.toList());
                        if (applicableVulnerabilities.isEmpty()) continue;
                        return (Json.Member)SearchResult.found((Tree)m, (String)("This dependency has the following vulnerabilities:\n" + applicableVulnerabilities.stream().map(v -> String.format("%s (%s severity%s) - %s", new Object[]{v.getCve(), v.getSeverity(), StringUtils.isBlank((String)v.getFixedVersion()) ? "" : ", fixed in " + v.getFixedVersion(), v.getSummary()})).collect(Collectors.joining("\n"))));
                    }
                }
                return m;
            }
        });
    }

    @ConstructorProperties(value={"addMarkers"})
    @Generated
    public DependencyVulnerabilityCheck(@Nullable Boolean addMarkers) {
        this.addMarkers = addMarkers;
    }

    @Generated
    public VersionParser getVersionParser() {
        return this.versionParser;
    }

    @Generated
    public VulnerabilityReport getReport() {
        return this.report;
    }

    @Generated
    public @Nullable Boolean getAddMarkers() {
        return this.addMarkers;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyVulnerabilityCheck(versionParser=" + this.getVersionParser() + ", report=" + (Object)((Object)this.getReport()) + ", addMarkers=" + this.getAddMarkers() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyVulnerabilityCheck)) {
            return false;
        }
        DependencyVulnerabilityCheck other = (DependencyVulnerabilityCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addMarkers = this.getAddMarkers();
        Boolean other$addMarkers = other.getAddMarkers();
        return !(this$addMarkers == null ? other$addMarkers != null : !((Object)this$addMarkers).equals(other$addMarkers));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyVulnerabilityCheck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addMarkers = this.getAddMarkers();
        result = result * 59 + ($addMarkers == null ? 43 : ((Object)$addMarkers).hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Map<String, List<Vulnerability>> db;
        private final Map<NameVersion, Set<Vulnerability>> vulnerabilities;

        @ConstructorProperties(value={"db", "vulnerabilities"})
        @Generated
        public Accumulator(Map<String, List<Vulnerability>> db, Map<NameVersion, Set<Vulnerability>> vulnerabilities) {
            this.db = db;
            this.vulnerabilities = vulnerabilities;
        }

        @Generated
        public Map<String, List<Vulnerability>> getDb() {
            return this.db;
        }

        @Generated
        public Map<NameVersion, Set<Vulnerability>> getVulnerabilities() {
            return this.vulnerabilities;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Map<String, List<Vulnerability>> this$db = this.getDb();
            Map<String, List<Vulnerability>> other$db = other.getDb();
            if (this$db == null ? other$db != null : !((Object)this$db).equals(other$db)) {
                return false;
            }
            Map<NameVersion, Set<Vulnerability>> this$vulnerabilities = this.getVulnerabilities();
            Map<NameVersion, Set<Vulnerability>> other$vulnerabilities = other.getVulnerabilities();
            return !(this$vulnerabilities == null ? other$vulnerabilities != null : !((Object)this$vulnerabilities).equals(other$vulnerabilities));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, List<Vulnerability>> $db = this.getDb();
            result = result * 59 + ($db == null ? 43 : ((Object)$db).hashCode());
            Map<NameVersion, Set<Vulnerability>> $vulnerabilities = this.getVulnerabilities();
            result = result * 59 + ($vulnerabilities == null ? 43 : ((Object)$vulnerabilities).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.Accumulator(db=" + this.getDb() + ", vulnerabilities=" + this.getVulnerabilities() + ")";
        }

        static final class NameVersion {
            private final String name;
            private final String version;

            @ConstructorProperties(value={"name", "version"})
            @Generated
            public NameVersion(String name, String version) {
                this.name = name;
                this.version = version;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NameVersion)) {
                    return false;
                }
                NameVersion other = (NameVersion)o;
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "DependencyVulnerabilityCheck.Accumulator.NameVersion(name=" + this.getName() + ", version=" + this.getVersion() + ")";
            }
        }
    }
}

