/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceStreamCollectWithToList
extends Recipe {
    private static final MethodMatcher STREAM_COLLECT = new MethodMatcher("java.util.stream.Stream collect(java.util.stream.Collector)");
    private static final MethodMatcher COLLECT_TO_UNMODIFIABLE_LIST = new MethodMatcher("java.util.stream.Collectors toUnmodifiableList()");
    private static final MethodMatcher COLLECT_TO_LIST = new MethodMatcher("java.util.stream.Collectors toList()");
    @Option(displayName="Convert mutable `Collectors.toList()` to immutable", description="Also replace `Stream.collect(Collectors.toList())` with `Stream.toList()`. *BEWARE*: Attempts to modify the returned list, result in an `UnsupportedOperationException`!", required=false)
    private final @Nullable Boolean convertToList;
    private final String displayName = "Replace `Stream.collect(Collectors.toUnmodifiableList())` with `Stream.toList()`";
    private final String description = "Replace `Stream.collect(Collectors.toUnmodifiableList())` with Java 16+ `Stream.toList()`. Also replaces `Stream.collect(Collectors.toList())` if `convertToList` is set to `true`.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);
    private final Set<String> tags = new HashSet<String>(Collections.singletonList("RSPEC-S6204"));

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(16), new UsesMethod(STREAM_COLLECT), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(COLLECT_TO_UNMODIFIABLE_LIST), new UsesMethod(COLLECT_TO_LIST)})}), (TreeVisitor)new ReplaceCollectorToListVisitor(Boolean.TRUE.equals(this.convertToList)));
    }

    @ConstructorProperties(value={"convertToList"})
    @Generated
    public ReplaceStreamCollectWithToList(@Nullable Boolean convertToList) {
        this.convertToList = convertToList;
    }

    @Generated
    public @Nullable Boolean getConvertToList() {
        return this.convertToList;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceStreamCollectWithToList(convertToList=" + this.getConvertToList() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStreamCollectWithToList)) {
            return false;
        }
        ReplaceStreamCollectWithToList other = (ReplaceStreamCollectWithToList)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$convertToList = this.getConvertToList();
        Boolean other$convertToList = other.getConvertToList();
        if (this$convertToList == null ? other$convertToList != null : !((Object)this$convertToList).equals(other$convertToList)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        if (this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceStreamCollectWithToList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $convertToList = this.getConvertToList();
        result = result * 59 + ($convertToList == null ? 43 : ((Object)$convertToList).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    private static final class ReplaceCollectorToListVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final boolean convertToList;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation result = super.visitMethodInvocation(method, (Object)ctx);
            if (!STREAM_COLLECT.matches((MethodCall)method)) {
                return result;
            }
            Expression command = (Expression)method.getArguments().get(0);
            if (COLLECT_TO_UNMODIFIABLE_LIST.matches(command) || this.convertToList && COLLECT_TO_LIST.matches(command)) {
                if (!this.areTypesCompatible(result)) {
                    return result;
                }
                this.maybeRemoveImport("java.util.stream.Collectors");
                J.MethodInvocation toList = (J.MethodInvocation)JavaTemplate.apply((String)"#{any(java.util.stream.Stream)}.toList()", (Cursor)this.updateCursor((Tree)result), (JavaCoordinates)result.getCoordinates().replace(), (Object[])new Object[]{result.getSelect()});
                return toList.getPadding().withSelect(result.getPadding().getSelect());
            }
            return result;
        }

        private boolean areTypesCompatible(J.MethodInvocation method) {
            if (method.getSelect() == null || method.getSelect().getType() == null || !(method.getSelect().getType() instanceof JavaType.Parameterized) || !(method.getType() instanceof JavaType.Parameterized)) {
                return false;
            }
            return TypeUtils.isOfType((JavaType)((JavaType)((JavaType.Parameterized)method.getSelect().getType()).getTypeParameters().get(0)), (JavaType)((JavaType)((JavaType.Parameterized)method.getType()).getTypeParameters().get(0)));
        }

        @ConstructorProperties(value={"convertToList"})
        @Generated
        public ReplaceCollectorToListVisitor(boolean convertToList) {
            this.convertToList = convertToList;
        }
    }
}

