/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lang.SwitchUtils;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class SwitchCaseReturnsToSwitchExpression
extends Recipe {
    private final String displayName = "Convert switch cases where every case returns into a returned switch expression";
    private final String description = "Switch statements where each case returns a value can be converted to a switch expression that returns the value directly. This recipe is only applicable for Java 21 and later.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                AtomicReference<Boolean> newReturn = new AtomicReference<Boolean>(false);
                return b.withStatements(ListUtils.map((List)b.getStatements(), statement -> {
                    J.Switch sw;
                    if (((Boolean)newReturn.get()).booleanValue()) {
                        return null;
                    }
                    if (statement instanceof J.Switch && this.canConvertToSwitchExpression(sw = (J.Switch)statement)) {
                        newReturn.set(true);
                        J.SwitchExpression switchExpression = this.convertToSwitchExpression(sw);
                        return new J.Return(Tree.randomId(), sw.getPrefix(), Markers.EMPTY, (Expression)switchExpression);
                    }
                    return statement;
                }));
            }

            private boolean canConvertToSwitchExpression(J.Switch switchStatement) {
                for (Statement statement : switchStatement.getCases().getStatements()) {
                    J body;
                    if (!(statement instanceof J.Case)) {
                        return false;
                    }
                    J.Case caseStatement = (J.Case)statement;
                    if (!(caseStatement.getBody() != null ? ((body = caseStatement.getBody()) instanceof J.Block ? !this.isReturnCase(((J.Block)body).getStatements()) : !(body instanceof J.Return)) : !this.isReturnCase(caseStatement.getStatements()))) continue;
                    return false;
                }
                return SwitchUtils.coversAllPossibleValues(switchStatement);
            }

            private boolean isReturnCase(List<Statement> statements) {
                if (statements.size() != 1) {
                    return false;
                }
                if (statements.get(0) instanceof J.Block) {
                    return this.isReturnCase(((J.Block)statements.get(0)).getStatements());
                }
                return statements.get(0) instanceof J.Return;
            }

            private J.SwitchExpression convertToSwitchExpression(J.Switch switchStatement) {
                JavaType returnType = this.extractReturnType(switchStatement);
                List convertedCases = ListUtils.map((List)switchStatement.getCases().getStatements(), statement -> {
                    J.Case caseStatement = (J.Case)statement;
                    if (caseStatement.getBody() != null) {
                        J.Return ret;
                        J body = caseStatement.getBody();
                        if (body instanceof J.Block && ((J.Block)body).getStatements().size() == 1) {
                            body = (J)((J.Block)body).getStatements().get(0);
                        }
                        if (body instanceof J.Return && (ret = (J.Return)body).getExpression() != null) {
                            return caseStatement.withBody((J)ret.getExpression());
                        }
                    } else {
                        Expression returnExpression = this.extractReturnExpression(caseStatement.getStatements());
                        if (returnExpression != null) {
                            JContainer caseLabels = caseStatement.getPadding().getCaseLabels();
                            JContainer updatedLabels = caseLabels.getPadding().withElements(ListUtils.mapLast((List)caseLabels.getPadding().getElements(), elem -> elem.withAfter(Space.SINGLE_SPACE)));
                            return caseStatement.withStatements(null).withBody(returnExpression.withPrefix(Space.SINGLE_SPACE)).withType(J.Case.Type.Rule).getPadding().withCaseLabels(updatedLabels);
                        }
                    }
                    return caseStatement;
                });
                return new J.SwitchExpression(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, switchStatement.getSelector(), switchStatement.getCases().withStatements(convertedCases), returnType);
            }

            private @Nullable JavaType extractReturnType(J.Switch switchStatement) {
                for (Statement statement : switchStatement.getCases().getStatements()) {
                    J.Case caseStatement = (J.Case)statement;
                    if (caseStatement.getBody() != null) {
                        J.Return ret;
                        J body = caseStatement.getBody();
                        if (body instanceof J.Block && ((J.Block)body).getStatements().size() == 1) {
                            body = (J)((J.Block)body).getStatements().get(0);
                        }
                        if (!(body instanceof J.Return) || (ret = (J.Return)body).getExpression() == null || ret.getExpression().getType() == null) continue;
                        return ret.getExpression().getType();
                    }
                    Expression returnExpression = this.extractReturnExpression(caseStatement.getStatements());
                    if (returnExpression == null || returnExpression.getType() == null) continue;
                    return returnExpression.getType();
                }
                return null;
            }

            private @Nullable Expression extractReturnExpression(List<Statement> statements) {
                J.Block block;
                if (statements.size() != 1) {
                    return null;
                }
                if (statements.get(0) instanceof J.Block && (block = (J.Block)statements.get(0)).getStatements().size() == 1 && block.getStatements().get(0) instanceof J.Return) {
                    return ((J.Return)block.getStatements().get(0)).getExpression();
                }
                if (statements.get(0) instanceof J.Return) {
                    return ((J.Return)statements.get(0)).getExpression();
                }
                return null;
            }
        });
    }

    @Generated
    public SwitchCaseReturnsToSwitchExpression() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SwitchCaseReturnsToSwitchExpression(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchCaseReturnsToSwitchExpression)) {
            return false;
        }
        SwitchCaseReturnsToSwitchExpression other = (SwitchCaseReturnsToSwitchExpression)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof SwitchCaseReturnsToSwitchExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

