/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.VariableReferences;

public class MigrateMainMethodToInstanceMain
extends Recipe {
    private static final MethodMatcher MAIN_METHOD_MATCHER = new MethodMatcher("*..* main(String[])", false);
    final String displayName = "Migrate `public static void main(String[] args)` to instance `void main()`";
    final String description = "Migrate `public static void main(String[] args)` method to instance `void main()` method when the `args` parameter is unused, as supported by JEP 512 in Java 25+.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(25), new DeclaresMethod(MAIN_METHOD_MATCHER)});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (!(enclosingClass != null && MAIN_METHOD_MATCHER.matches(md, enclosingClass) && md.getReturnTypeExpression() != null && md.getReturnTypeExpression().getType() == JavaType.Primitive.Void && md.hasModifier(J.Modifier.Type.Public) && md.hasModifier(J.Modifier.Type.Static) && md.getBody() != null)) {
                    return md;
                }
                J.VariableDeclarations param = (J.VariableDeclarations)md.getParameters().get(0);
                JavaType paramType = param.getType();
                if (!TypeUtils.isOfClassType((JavaType)paramType, (String)"java.lang.String") || !(paramType instanceof JavaType.Array)) {
                    return md;
                }
                if (this.hasSpringBootApplicationAnnotation(enclosingClass) || !this.hasNoArgConstructor(enclosingClass) || this.isMainMethodReferenced(md)) {
                    return md;
                }
                J.Identifier variableName = ((J.VariableDeclarations.NamedVariable)param.getVariables().get(0)).getName();
                if (VariableReferences.findRhsReferences((J)md.getBody(), (J.Identifier)variableName).isEmpty()) {
                    md = md.withParameters(Collections.emptyList());
                }
                return md.withReturnTypeExpression((TypeTree)md.getReturnTypeExpression().withPrefix(((J.Modifier)md.getModifiers().get(0)).getPrefix())).withModifiers(Collections.emptyList());
            }

            private boolean hasSpringBootApplicationAnnotation(J.ClassDeclaration classDecl) {
                return classDecl.getLeadingAnnotations().stream().anyMatch(ann -> TypeUtils.isOfClassType((JavaType)ann.getType(), (String)"org.springframework.boot.autoconfigure.SpringBootApplication"));
            }

            private boolean hasNoArgConstructor(J.ClassDeclaration classDecl) {
                List constructors = classDecl.getBody().getStatements().stream().filter(stmt -> stmt instanceof J.MethodDeclaration).map(stmt -> (J.MethodDeclaration)stmt).filter(J.MethodDeclaration::isConstructor).collect(Collectors.toList());
                if (constructors.isEmpty()) {
                    return true;
                }
                return constructors.stream().anyMatch(ctor -> (ctor.getParameters().isEmpty() || ctor.getParameters().size() == 1 && ctor.getParameters().get(0) instanceof J.Empty) && ctor.hasModifier(J.Modifier.Type.Public));
            }

            private boolean isMainMethodReferenced(final J.MethodDeclaration mainMethod) {
                J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
                if (cu == null) {
                    return false;
                }
                return ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                    public J.MemberReference visitMemberReference(J.MemberReference memberRef, AtomicBoolean referenced) {
                        if ("main".equals(memberRef.getReference().getSimpleName()) && memberRef.getMethodType() != null && TypeUtils.isOfType((JavaType)memberRef.getMethodType(), (JavaType)mainMethod.getMethodType())) {
                            referenced.set(true);
                        }
                        return super.visitMemberReference(memberRef, (Object)referenced);
                    }
                }.reduce((Tree)cu, (Object)new AtomicBoolean())).get();
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

