/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class AddDefaultConstructorToEntityClass
extends Recipe {
    final String displayName = "`@Entity` objects with constructors must also have a default constructor";
    final String description = "When a Java Persistence API (JPA) entity class has a constructor with arguments, the class must also have a default, no-argument constructor. The OpenJPA implementation automatically generates the no-argument constructor, but the EclipseLink implementation does not.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Entity", Boolean.valueOf(true)), new UsesType("javax.persistence.MappedSuperclass", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (FindAnnotations.find((J)classDecl, (String)"javax.persistence.Entity").isEmpty() && FindAnnotations.find((J)classDecl, (String)"javax.persistence.MappedSuperclass").isEmpty()) {
                    return classDecl;
                }
                if (classDecl.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).filter(J.MethodDeclaration::isConstructor).anyMatch(constructor -> constructor.getParameters().get(0) instanceof J.Empty)) {
                    return classDecl;
                }
                return classDecl.withBody((J.Block)JavaTemplate.builder((String)"public #{}(){}").contextSensitive().build().apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().firstStatement(), new Object[]{classDecl.getSimpleName()}));
            }
        });
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDefaultConstructorToEntityClass)) {
            return false;
        }
        AddDefaultConstructorToEntityClass other = (AddDefaultConstructorToEntityClass)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddDefaultConstructorToEntityClass;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

