/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class UpdateGetRealPath
extends Recipe {
    final String displayName = "Updates `getRealPath()` to call `getContext()` followed by `getRealPath()`";
    final String description = "Updates `getRealPath()` for `jakarta.servlet.ServletRequest` and `jakarta.servlet.ServletRequestWrapper` to use `ServletContext.getRealPath(String)`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final MethodMatcher METHOD_PATTERN = new MethodMatcher("jakarta.servlet.ServletRequest* getRealPath(String)", false);

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (this.METHOD_PATTERN.matches((MethodCall)method)) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any()}.getServletContext().getRealPath(#{any(String)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.servlet-api-6.0.0"})).build().apply(this.updateCursor((Tree)method), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0)});
                }
                return method;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

