/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.RemoveUnusedLocalVariables;
import org.openrewrite.staticanalysis.SimplifyConstantIfBranchExecution;

public class RemoveBeanIsNullable
extends Recipe {
    final String displayName = "Remove `Bean.isNullable()`";
    final String description = "`Bean.isNullable()` has been removed in CDI 4.0.0, and now always returns `false`.";
    private static final MethodMatcher BEAN_ISNULLABLE = new MethodMatcher("jakarta.enterprise.inject.spi.Bean isNullable()", false);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (BEAN_ISNULLABLE.matches((MethodCall)method)) {
                    this.doAfterVisit(new SimplifyConstantIfBranchExecution().getVisitor());
                    this.doAfterVisit(new RemoveUnusedLocalVariables(null, null, null).getVisitor());
                    return new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, (Object)Boolean.FALSE, "false", null, JavaType.Primitive.Boolean);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

