/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public final class HasNoJakartaAnnotations
extends ScanningRecipe<Accumulator> {
    private final String displayName = "Project has no Jakarta annotations";
    private final String description = "Mark all source as found per `JavaProject` where no Jakarta annotations are found. This is useful mostly as a precondition for recipes that require Jakarta annotations to be present.";

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashSet<JavaProject>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (tree instanceof J) {
                    tree.getMarkers().findFirst(JavaProject.class).filter(jp -> !acc.getProjectsWithDependency().contains(jp)).filter(jp -> !FindAnnotations.find((J)((J)tree), (String)"@jakarta.annotation.*", (boolean)true).isEmpty()).ifPresent(jp -> acc.getProjectsWithDependency().add((JavaProject)jp));
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                return tree.getMarkers().findFirst(JavaProject.class).filter(it -> !acc.getProjectsWithDependency().contains(it)).map(__ -> SearchResult.found((Tree)tree, (String)"Project has no Jakarta annotations")).orElse(tree);
            }
        };
    }

    @Generated
    public HasNoJakartaAnnotations() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HasNoJakartaAnnotations(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasNoJakartaAnnotations)) {
            return false;
        }
        HasNoJakartaAnnotations other = (HasNoJakartaAnnotations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HasNoJakartaAnnotations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Set<JavaProject> projectsWithDependency;

        @ConstructorProperties(value={"projectsWithDependency"})
        @Generated
        public Accumulator(Set<JavaProject> projectsWithDependency) {
            this.projectsWithDependency = projectsWithDependency;
        }

        @Generated
        public Set<JavaProject> getProjectsWithDependency() {
            return this.projectsWithDependency;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<JavaProject> this$projectsWithDependency = this.getProjectsWithDependency();
            Set<JavaProject> other$projectsWithDependency = other.getProjectsWithDependency();
            return !(this$projectsWithDependency == null ? other$projectsWithDependency != null : !((Object)this$projectsWithDependency).equals(other$projectsWithDependency));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<JavaProject> $projectsWithDependency = this.getProjectsWithDependency();
            result = result * 59 + ($projectsWithDependency == null ? 43 : ((Object)$projectsWithDependency).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "HasNoJakartaAnnotations.Accumulator(projectsWithDependency=" + this.getProjectsWithDependency() + ")";
        }
    }
}

