/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class PreferJavaUtilOptionalOrSupplier
extends Recipe {
    static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.base.Optional or(com.google.common.base.Optional)");
    private final String displayName = "Prefer `java.util.Optional#or(Supplier<T extends java.util.Optional<T>>)`";
    private final String description = "Prefer `java.util.Optional#or(Supplier<T extends java.util.Optional<T>>)` over `com.google.common.base.Optional#or(com.google.common.base.Optional).";
    private final Set<String> tags = new HashSet<String>(Arrays.asList("RSPEC-S4738", "guava"));

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(METHOD_MATCHER)}), (TreeVisitor)new PreferJavaUtilOptionalOrSupplierVisitor());
    }

    @Generated
    public PreferJavaUtilOptionalOrSupplier() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "PreferJavaUtilOptionalOrSupplier(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferJavaUtilOptionalOrSupplier)) {
            return false;
        }
        PreferJavaUtilOptionalOrSupplier other = (PreferJavaUtilOptionalOrSupplier)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PreferJavaUtilOptionalOrSupplier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    private static class PreferJavaUtilOptionalOrSupplierVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private PreferJavaUtilOptionalOrSupplierVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (METHOD_MATCHER.matches((MethodCall)method)) {
                mi = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.Optional)}.or(() -> #{any(java.util.Optional)})").contextSensitive().imports(new String[]{"java.util.Optional"}).build().apply(this.updateCursor((Tree)mi), method.getCoordinates().replace(), new Object[]{mi.getSelect(), mi.getArguments().get(0)});
                this.maybeRemoveImport("com.google.common.base.Optional");
                this.maybeAddImport("java.util.Optional");
            }
            return mi;
        }
    }
}

