/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.MethodCall;

public class NoMapsAndSetsWithExpectedSize
extends Recipe {
    private static final MethodMatcher NEW_HASHMAP = new MethodMatcher("com.google.common.collect.Maps newHashMapWithExpectedSize(int)", false);
    private static final MethodMatcher NEW_LINKED_HASHMAP = new MethodMatcher("com.google.common.collect.Maps newLinkedHashMapWithExpectedSize(int)", false);
    private static final MethodMatcher NEW_HASHSET = new MethodMatcher("com.google.common.collect.Sets newHashSetWithExpectedSize(int)", false);
    private static final MethodMatcher NEW_LINKED_HASHSET = new MethodMatcher("com.google.common.collect.Sets newLinkedHashSetWithExpectedSize(int)", false);
    final String displayName = "Prefer JDK methods for Maps and Sets of an expected size";
    final String description = "Prefer Java 19+ methods to create Maps and Sets of an expected size instead of using Guava methods.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(19), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(NEW_HASHMAP), new UsesMethod(NEW_LINKED_HASHMAP), new UsesMethod(NEW_HASHSET), new UsesMethod(NEW_LINKED_HASHSET)})}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation j = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (NEW_HASHMAP.matches((MethodCall)j)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.HashMap");
                    JavaCoordinates coordinates = j.getCoordinates().replace();
                    return JavaTemplate.builder((String)"new HashMap<>(#{any()})").imports(new String[]{"java.util.HashMap"}).build().apply(this.getCursor(), coordinates, j.getArguments().toArray());
                }
                if (NEW_LINKED_HASHMAP.matches((MethodCall)j)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.LinkedHashMap");
                    JavaCoordinates coordinates = j.getCoordinates().replace();
                    return JavaTemplate.builder((String)"new LinkedHashMap<>(#{any()})").imports(new String[]{"java.util.LinkedHashMap"}).build().apply(this.getCursor(), coordinates, j.getArguments().toArray());
                }
                if (NEW_HASHSET.matches((MethodCall)j)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.HashSet");
                    JavaCoordinates coordinates = j.getCoordinates().replace();
                    return JavaTemplate.builder((String)"new HashSet<>(#{any()})").imports(new String[]{"java.util.HashSet"}).build().apply(this.getCursor(), coordinates, j.getArguments().toArray());
                }
                if (NEW_LINKED_HASHSET.matches((MethodCall)j)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    JavaCoordinates coordinates = j.getCoordinates().replace();
                    return JavaTemplate.builder((String)"new LinkedHashSet<>(#{any()})").imports(new String[]{"java.util.LinkedHashSet"}).build().apply(this.getCursor(), coordinates, j.getArguments().toArray());
                }
                return j;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

