/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class NoGuavaPredicatesInstanceOf
extends Recipe {
    private static final MethodMatcher PREDICATES_INSTANCE_OF = new MethodMatcher("com.google.common.base.Predicates instanceOf(..)");
    final String displayName = "Prefer `A.class::isInstance`";
    final String description = "Prefer `A.class::isInstance` over `Predicates.instanceOf(A.class)`.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(PREDICATES_INSTANCE_OF), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (PREDICATES_INSTANCE_OF.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Predicates");
                    Expression clazz = (Expression)method.getArguments().get(0);
                    return new J.MemberReference(Tree.randomId(), method.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)clazz), null, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "isInstance", null, null)), null, null, null);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

