/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaPredicatesAndOr
extends Recipe {
    private static final MethodMatcher PREDICATES_AND = new MethodMatcher("com.google.common.base.Predicates and(..)");
    private static final MethodMatcher PREDICATES_OR = new MethodMatcher("com.google.common.base.Predicates or(..)");
    private static final List<MethodMatcher> PREDICATES_METHODS_HANDLED = Arrays.asList(new MethodMatcher("com.google.common.base.Predicates equalTo(..)"), PREDICATES_AND, PREDICATES_OR, new MethodMatcher("com.google.common.base.Predicates not(..)"));
    final String displayName = "Prefer `Predicate.and(Predicate)`";
    final String description = "Prefer `Predicate.and(Predicate)` over `Predicates.and(Predicate, Predicate)`.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor precondition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(PREDICATES_AND), new UsesMethod(PREDICATES_OR)});
        return Preconditions.check((TreeVisitor)precondition, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (PREDICATES_AND.matches((MethodCall)method)) {
                    return this.handlePredicatesMethod(method, "and");
                }
                if (PREDICATES_OR.matches((MethodCall)method)) {
                    return this.handlePredicatesMethod(method, "or");
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            private J handlePredicatesMethod(J.MethodInvocation method, String operation) {
                List arguments = method.getArguments();
                if (arguments.size() < 2) {
                    return method;
                }
                if (NoGuavaPredicatesAndOr.this.atLeastOneArgumentIsMethodInvocationOfPredicates(arguments)) {
                    return method;
                }
                this.maybeRemoveImport("com.google.common.base.Predicates");
                Expression result = (Expression)arguments.get(0);
                if ((result instanceof J.MemberReference || result instanceof J.Lambda) && result.getType() != null) {
                    String typeString = result.getType().toString().replace("com.google.common.base.", "");
                    result = (Expression)JavaTemplate.apply((String)("((" + typeString + ") #{any()})"), (Cursor)this.getCursor(), (JavaCoordinates)method.getCoordinates().replace(), (Object[])new Object[]{result});
                }
                for (int i = 1; i < arguments.size(); ++i) {
                    result = (Expression)JavaTemplate.apply((String)("#{any(java.util.function.Predicate)}." + operation + "(#{any(java.util.function.Predicate)})"), (Cursor)this.getCursor(), (JavaCoordinates)method.getCoordinates().replace(), (Object[])new Object[]{result, arguments.get(i)});
                }
                this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)result));
                return result;
            }
        });
    }

    private boolean atLeastOneArgumentIsMethodInvocationOfPredicates(List<Expression> arguments) {
        for (Expression expression : arguments) {
            JavaType.Method methodType;
            if (!(expression instanceof J.MethodInvocation) || this.isMethodHandled((J.MethodInvocation)expression) || (methodType = ((J.MethodInvocation)expression).getMethodType()) == null || !TypeUtils.isOfClassType((JavaType)methodType.getDeclaringType(), (String)"com.google.common.base.Predicates")) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodHandled(J.MethodInvocation methodInvocation) {
        for (MethodMatcher methodMatcher : PREDICATES_METHODS_HANDLED) {
            if (!methodMatcher.matches((MethodCall)methodInvocation)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

