/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class ReferenceCloneMethod
extends Recipe {
    private static final MethodMatcher REFERENCE_CLONE = new MethodMatcher("java.lang.ref.Reference clone()", true);
    private final String displayName = "Replace `java.lang.ref.Reference.clone()` with constructor call";
    private final String description = "The recipe replaces any clone calls that may resolve to a `java.lang.ref.Reference.clone()` or any of its known subclasses: `java.lang.ref.PhantomReference`, `java.lang.ref.SoftReference`, and `java.lang.ref.WeakReference` with a constructor call passing in the referent and reference queue as parameters.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(REFERENCE_CLONE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private static final String REFERENCE_CLONE_REPLACED = "REFERENCE_CLONE_REPLACED";

            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                J.TypeCast tc;
                J j = super.visitTypeCast(typeCast, (Object)ctx);
                if (Boolean.TRUE.equals(this.getCursor().pollNearestMessage(REFERENCE_CLONE_REPLACED)) && j instanceof J.TypeCast && TypeUtils.isOfType((JavaType)(tc = (J.TypeCast)j).getType(), (JavaType)tc.getExpression().getType())) {
                    return tc.getExpression();
                }
                return j;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                super.visitMethodInvocation(method, (Object)ctx);
                if (REFERENCE_CLONE.matches((MethodCall)method) && method.getSelect() instanceof J.Identifier) {
                    J.Identifier methodRef = (J.Identifier)method.getSelect();
                    String template = "new " + methodRef.getType().toString() + "(" + methodRef.getSimpleName() + ", new ReferenceQueue<>())";
                    this.getCursor().putMessageOnFirstEnclosing(J.TypeCast.class, REFERENCE_CLONE_REPLACED, (Object)true);
                    J replacement = JavaTemplate.builder((String)template).contextSensitive().imports(new String[]{"java.lang.ref.ReferenceQueue"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                    this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)replacement));
                    return replacement;
                }
                return method;
            }
        });
    }

    @Generated
    public ReferenceCloneMethod() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReferenceCloneMethod(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceCloneMethod)) {
            return false;
        }
        ReferenceCloneMethod other = (ReferenceCloneMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReferenceCloneMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

