/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JREThrowableFinalMethods
extends Recipe {
    private final String methodPatternAddSuppressed;
    private final String methodPatternGetSuppressed;
    final String displayName = "Rename final method declarations `getSuppressed()` and `addSuppressed(Throwable exception)` in classes that extend `Throwable`";
    final String description = "The recipe renames  `getSuppressed()` and `addSuppressed(Throwable exception)` methods  in classes that extend `java.lang.Throwable` to `myGetSuppressed` and `myAddSuppressed(Throwable)`. These methods were added to Throwable in Java 7 and are marked final which cannot be overridden.";

    @JsonCreator
    public JREThrowableFinalMethods() {
        this.methodPatternAddSuppressed = "*..* addSuppressed(Throwable)";
        this.methodPatternGetSuppressed = "*..* getSuppressed()";
    }

    JREThrowableFinalMethods(String methodPatternAddSuppressed, String methodPatternGetSuppressed) {
        this.methodPatternAddSuppressed = methodPatternAddSuppressed;
        this.methodPatternGetSuppressed = methodPatternGetSuppressed;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(1, 6), new UsesType("java.lang.Throwable", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher METHOD_ADDSUPPRESSED;
            private final MethodMatcher METHOD_GETSUPPRESSED;
            private final String JAVA_THROWABLE_CLASS = "java.lang.Throwable";
            {
                this.METHOD_ADDSUPPRESSED = new MethodMatcher(JREThrowableFinalMethods.this.methodPatternAddSuppressed, false);
                this.METHOD_GETSUPPRESSED = new MethodMatcher(JREThrowableFinalMethods.this.methodPatternGetSuppressed, false);
                this.JAVA_THROWABLE_CLASS = "java.lang.Throwable";
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
                J.ClassDeclaration classDeclaration;
                J.MethodDeclaration md = super.visitMethodDeclaration(methodDecl, (Object)ctx);
                JavaType.Method mt = md.getMethodType();
                if (mt != null && TypeUtils.isAssignableTo((String)"java.lang.Throwable", (JavaType)mt.getDeclaringType()) && (classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class)) != null) {
                    if (this.METHOD_ADDSUPPRESSED.matches(md, classDeclaration)) {
                        JavaType.Method myAddSuppressed = mt.withName("myAddSuppressed");
                        return md.withName(md.getName().withSimpleName("myAddSuppressed").withType((JavaType)myAddSuppressed)).withMethodType(myAddSuppressed);
                    }
                    if (this.METHOD_GETSUPPRESSED.matches(md, classDeclaration)) {
                        JavaType.Method myGetSuppressed = mt.withName("myGetSuppressed");
                        return md.withName(md.getName().withSimpleName("myGetSuppressed").withType((JavaType)myGetSuppressed)).withMethodType(myGetSuppressed);
                    }
                }
                return md;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInv, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(methodInv, (Object)ctx);
                JavaType.Method mt = mi.getMethodType();
                if (mt != null && TypeUtils.isAssignableTo((String)"java.lang.Throwable", (JavaType)mt.getDeclaringType())) {
                    if (this.METHOD_ADDSUPPRESSED.matches((MethodCall)mi)) {
                        JavaType.Method myAddSuppressed = mt.withName("myAddSuppressed");
                        mi = mi.withName(mi.getName().withSimpleName("myAddSuppressed").withType((JavaType)myAddSuppressed)).withMethodType(myAddSuppressed);
                    } else if (this.METHOD_GETSUPPRESSED.matches((MethodCall)mi)) {
                        JavaType.Method myGetSuppressed = mt.withName("myGetSuppressed");
                        mi = mi.withName(mi.getName().withSimpleName("myGetSuppressed").withType((JavaType)myGetSuppressed)).withMethodType(myGetSuppressed);
                    }
                }
                return mi;
            }
        });
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JREThrowableFinalMethods)) {
            return false;
        }
        JREThrowableFinalMethods other = (JREThrowableFinalMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPatternAddSuppressed = this.methodPatternAddSuppressed;
        String other$methodPatternAddSuppressed = other.methodPatternAddSuppressed;
        if (this$methodPatternAddSuppressed == null ? other$methodPatternAddSuppressed != null : !this$methodPatternAddSuppressed.equals(other$methodPatternAddSuppressed)) {
            return false;
        }
        String this$methodPatternGetSuppressed = this.methodPatternGetSuppressed;
        String other$methodPatternGetSuppressed = other.methodPatternGetSuppressed;
        if (this$methodPatternGetSuppressed == null ? other$methodPatternGetSuppressed != null : !this$methodPatternGetSuppressed.equals(other$methodPatternGetSuppressed)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JREThrowableFinalMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPatternAddSuppressed = this.methodPatternAddSuppressed;
        result = result * 59 + ($methodPatternAddSuppressed == null ? 43 : $methodPatternAddSuppressed.hashCode());
        String $methodPatternGetSuppressed = this.methodPatternGetSuppressed;
        result = result * 59 + ($methodPatternGetSuppressed == null ? 43 : $methodPatternGetSuppressed.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

