/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class StringRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "A collection of `String` rules";
    }

    public String getDescription() {
        return "A collection of rules for refactoring methods called on `String` instances in Java code.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new RedundantCallRecipe(), new IndexOfStringRecipe(), new IndexOfCharRecipe(), new UseEqualsIgnoreCaseRecipe()});
    }

    @NullMarked
    public static class RedundantCallRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace redundant `String` method calls with self";
        }

        public String getDescription() {
            return "Replace redundant `substring(..)` and `toString()` method calls with the `String` self.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(0, #{string}.length())").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(0)").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.toString()").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String substring(..)", true), new UsesMethod("java.lang.String toString(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String length(..)", true), new UsesMethod("java.lang.String substring(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IndexOfStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `String.indexOf(String, 0)` with `String.indexOf(String)`";
        }

        public String getDescription() {
            return "Replace `String.indexOf(String str, int fromIndex)` with `String.indexOf(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate indexOfZero;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.indexOfZero == null) {
                        this.indexOfZero = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.indexOf(#{test:any(java.lang.String)}, 0)").build();
                    }
                    if ((matcher = this.indexOfZero.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.indexOf(#{test:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String indexOf(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IndexOfCharRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `String.indexOf(char, 0)` with `String.indexOf(char)`";
        }

        public String getDescription() {
            return "Replace `String.indexOf(char ch, int fromIndex)` with `String.indexOf(char)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate indexOfZero;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.indexOfZero == null) {
                        this.indexOfZero = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.indexOf(#{test:any(char)}, 0)").build();
                    }
                    if ((matcher = this.indexOfZero.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.indexOf(#{test:any(char)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String indexOf(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UseEqualsIgnoreCaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace lower and upper case `String` comparisons with `String.equalsIgnoreCase(String)`";
        }

        public String getDescription() {
            return "Replace `String` equality comparisons involving `.toLowerCase()` or `.toUpperCase()` with `String.equalsIgnoreCase(String anotherString)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate bothLowerCase;
                JavaTemplate bothUpperCase;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.bothLowerCase == null) {
                        this.bothLowerCase = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.toLowerCase().equals(#{test:any(java.lang.String)}.toLowerCase())").build();
                    }
                    if ((matcher = this.bothLowerCase.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.equalsIgnoreCase(#{test:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.bothUpperCase == null) {
                        this.bothUpperCase = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.toUpperCase().equals(#{test:any(java.lang.String)}.toUpperCase())").build();
                    }
                    if ((matcher = this.bothUpperCase.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.equalsIgnoreCase(#{test:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String equals(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String toLowerCase(..)", true), new UsesMethod("java.lang.String toUpperCase(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }
}

