/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class IteratorNext
extends Recipe {
    private static final MethodMatcher ITERATOR_MATCHER = new MethodMatcher("java.util.Collection iterator()", true);
    private static final MethodMatcher NEXT_MATCHER = new MethodMatcher("java.util.Iterator next()", true);

    public String getDisplayName() {
        return "Replace `iterator().next()` with `getFirst()`";
    }

    public String getDescription() {
        return "Replace `SequencedCollection.iterator().next()` with `getFirst()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(ITERATOR_MATCHER), new UsesMethod(NEXT_MATCHER)})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation iteratorInvocation;
                Expression iteratorSelect;
                J.MethodInvocation nextInvocation = super.visitMethodInvocation(method, (Object)ctx);
                if (NEXT_MATCHER.matches((MethodCall)nextInvocation) && ITERATOR_MATCHER.matches(nextInvocation.getSelect()) && (iteratorSelect = (iteratorInvocation = (J.MethodInvocation)nextInvocation.getSelect()).getSelect()) != null && TypeUtils.isAssignableTo((String)"java.util.SequencedCollection", (JavaType)iteratorSelect.getType())) {
                    JavaType.Method getFirst = iteratorInvocation.getMethodType().withName("getFirst");
                    return iteratorInvocation.withName(iteratorInvocation.getName().withSimpleName("getFirst").withType((JavaType)getFirst)).withMethodType(getFirst).withPrefix(nextInvocation.getPrefix());
                }
                return nextInvocation;
            }
        });
    }
}

