/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaOptionalFromJavaUtil
extends Recipe {
    static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.base.Optional fromJavaUtil(java.util.Optional)");

    public String getDisplayName() {
        return "Replace `com.google.common.base.Optional#fromJavaUtil(java.util.Optional)` with argument";
    }

    public String getDescription() {
        return "Replaces `com.google.common.base.Optional#fromJavaUtil(java.util.Optional)` with argument.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-S4738", "guava"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new ReplaceFromJavaUtilVisitor());
    }

    private static class ReplaceFromJavaUtilVisitor
    extends JavaVisitor<ExecutionContext> {
        private ReplaceFromJavaUtilVisitor() {
        }

        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeRemoveImport("com.google.common.base.Optional");
            this.maybeAddImport("java.util.Optional");
            return c;
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi;
            J j = super.visitMethodInvocation(method, (Object)ctx);
            if (j instanceof J.MethodInvocation && METHOD_MATCHER.matches((MethodCall)(mi = (J.MethodInvocation)j))) {
                return ((Expression)mi.getArguments().get(0)).withPrefix(mi.getPrefix());
            }
            return j;
        }
    }
}

