/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class InlineMethodCalls
extends Recipe {
    private static final String INLINE_ME = "InlineMe";

    public String getDisplayName() {
        return "Inline methods annotated with `@InlineMe`";
    }

    public String getDescription() {
        return "Apply inlinings defined by Error Prone's [`@InlineMe` annotation](https://errorprone.info/docs/inlineme).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                InlineMeValues values = this.findInlineMeValues(mi.getMethodType());
                if (values == null) {
                    return mi;
                }
                Template template = values.template((MethodCall)mi);
                if (template == null) {
                    return mi;
                }
                this.removeAndAddImports((MethodCall)method, values.getImports(), values.getStaticImports());
                J replacement = JavaTemplate.builder((String)template.getString()).contextSensitive().imports(values.getImports().toArray(new String[0])).staticImports(values.getStaticImports().toArray(new String[0])).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), template.getParameters());
                return this.avoidMethodSelfReferences((MethodCall)mi, replacement);
            }

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                InlineMeValues values = this.findInlineMeValues(nc.getConstructorType());
                if (values == null) {
                    return nc;
                }
                Template template = values.template((MethodCall)nc);
                if (template == null) {
                    return nc;
                }
                this.removeAndAddImports((MethodCall)newClass, values.getImports(), values.getStaticImports());
                J replacement = JavaTemplate.builder((String)template.getString()).contextSensitive().imports(values.getImports().toArray(new String[0])).staticImports(values.getStaticImports().toArray(new String[0])).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build().apply(this.updateCursor((Tree)nc), nc.getCoordinates().replace(), template.getParameters());
                return this.avoidMethodSelfReferences((MethodCall)nc, replacement);
            }

            private @Nullable InlineMeValues findInlineMeValues(// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Method methodType) {
                if (methodType == null) {
                    return null;
                }
                List parameterNames = methodType.getParameterNames();
                if (!parameterNames.isEmpty() && "arg0".equals(parameterNames.get(0))) {
                    return null;
                }
                List annotations = methodType.getAnnotations();
                for (JavaType.FullyQualified annotation : annotations) {
                    if (!InlineMethodCalls.INLINE_ME.equals(annotation.getClassName())) continue;
                    return InlineMeValues.parse((JavaType.Annotation)annotation);
                }
                return null;
            }

            private void removeAndAddImports(MethodCall method, Set<String> templateImports, Set<String> templateStaticImports) {
                Set<String> originalImports = this.findOriginalImports(method);
                for (String originalImport : originalImports) {
                    if (templateImports.contains(originalImport) || templateStaticImports.contains(originalImport)) continue;
                    this.maybeRemoveImport(originalImport);
                }
                for (String importStr : templateImports) {
                    if (originalImports.contains(importStr)) continue;
                    this.maybeAddImport(importStr);
                }
                for (String staticImport : templateStaticImports) {
                    int lastDot;
                    if (originalImports.contains(staticImport) || 0 >= (lastDot = staticImport.lastIndexOf(46))) continue;
                    this.maybeAddImport(staticImport.substring(0, lastDot), staticImport.substring(lastDot + 1));
                }
            }

            private Set<String> findOriginalImports(MethodCall method) {
                return (Set)new JavaVisitor<Set<String>>(){

                    public @Nullable JavaType visitType(@Nullable JavaType javaType, Set<String> strings) {
                        JavaType jt = super.visitType(javaType, strings);
                        if (jt instanceof JavaType.FullyQualified) {
                            strings.add(((JavaType.FullyQualified)jt).getFullyQualifiedName());
                        }
                        return jt;
                    }

                    public J visitMethodInvocation(J.MethodInvocation methodInvocation, Set<String> staticImports) {
                        J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, staticImports);
                        JavaType.Method methodType = mi.getMethodType();
                        if (mi.getSelect() == null && methodType != null && methodType.hasFlags(new Flag[]{Flag.Static})) {
                            staticImports.add(String.format("%s.%s", methodType.getDeclaringType().getFullyQualifiedName(), methodType.getName()));
                        }
                        return mi;
                    }

                    public J visitIdentifier(J.Identifier identifier, Set<String> staticImports) {
                        J.Identifier id = (J.Identifier)super.visitIdentifier(identifier, staticImports);
                        JavaType.Variable fieldType = id.getFieldType();
                        if (fieldType != null && fieldType.hasFlags(new Flag[]{Flag.Static}) && fieldType.getOwner() instanceof JavaType.FullyQualified) {
                            staticImports.add(String.format("%s.%s", ((JavaType.FullyQualified)fieldType.getOwner()).getFullyQualifiedName(), fieldType.getName()));
                        }
                        return id;
                    }
                }.reduce((Tree)method, new HashSet());
            }

            private J avoidMethodSelfReferences(MethodCall original, J replacement) {
                JavaType.Method replacementMethodType;
                JavaType.Method method = replacementMethodType = replacement instanceof MethodCall ? ((MethodCall)replacement).getMethodType() : null;
                if (replacementMethodType == null) {
                    return replacement;
                }
                Cursor cursor = this.getCursor();
                while ((cursor = cursor.getParent()) != null) {
                    JavaType.Method cursorMethodType;
                    Object value = cursor.getValue();
                    if (value instanceof MethodCall) {
                        cursorMethodType = ((MethodCall)value).getMethodType();
                    } else {
                        if (!(value instanceof J.MethodDeclaration)) continue;
                        cursorMethodType = ((J.MethodDeclaration)value).getMethodType();
                    }
                    if (!TypeUtils.isOfType((JavaType)replacementMethodType, (JavaType)cursorMethodType)) continue;
                    return original;
                }
                return replacement;
            }
        };
    }

    private static final class Template {
        private final String string;
        private final Object[] parameters;

        @ConstructorProperties(value={"string", "parameters"})
        @Generated
        public Template(String string, Object[] parameters) {
            this.string = string;
            this.parameters = parameters;
        }

        @Generated
        public String getString() {
            return this.string;
        }

        @Generated
        public Object[] getParameters() {
            return this.parameters;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Template)) {
                return false;
            }
            Template other = (Template)o;
            String this$string = this.getString();
            String other$string = other.getString();
            if (this$string == null ? other$string != null : !this$string.equals(other$string)) {
                return false;
            }
            return Arrays.deepEquals(this.getParameters(), other.getParameters());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $string = this.getString();
            result = result * 59 + ($string == null ? 43 : $string.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParameters());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "InlineMethodCalls.Template(string=" + this.getString() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ")";
        }
    }

    private static final class InlineMeValues {
        private static final Pattern TEMPLATE_IDENTIFIER = Pattern.compile("#\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*):any\\(.*?\\)}");
        private final String replacement;
        private final Set<String> imports;
        private final Set<String> staticImports;

        static InlineMeValues parse(JavaType.Annotation annotation) {
            Map<String, Object> collect = annotation.getValues().stream().collect(Collectors.toMap(e -> ((JavaType.Method)e.getElement()).getName(), JavaType.Annotation.ElementValue::getValue));
            return new InlineMeValues((String)collect.get("replacement"), InlineMeValues.parseImports(collect.get("imports")), InlineMeValues.parseImports(collect.get("staticImports")));
        }

        private static Set<String> parseImports(@Nullable Object importsValue) {
            if (importsValue instanceof List) {
                return ((List)importsValue).stream().map(Object::toString).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }

        @Nullable Template template(MethodCall original) {
            JavaType.Method methodType = original.getMethodType();
            if (methodType == null) {
                return null;
            }
            String templateString = InlineMeValues.createTemplateString(original, this.replacement, methodType.getParameterNames());
            List<Object> parameters = InlineMeValues.createParameters(templateString, original);
            return new Template(templateString, parameters.toArray(new Object[0]));
        }

        private static String createTemplateString(MethodCall original, String replacement, List<String> originalParameterNames) {
            String templateString = original instanceof J.MethodInvocation && ((J.MethodInvocation)original).getSelect() == null && replacement.startsWith("this.") ? replacement.replaceFirst("^this.\\b", "") : replacement.replaceAll("\\bthis\\b", "#{this:any()}");
            for (String parameterName : originalParameterNames) {
                templateString = templateString.replaceAll(String.format("\\b%s\\b", parameterName), String.format("#{%s:any()}", parameterName));
            }
            return templateString;
        }

        private static List<Object> createParameters(String templateString, MethodCall original) {
            Expression select;
            HashMap<String, Expression> lookup = new HashMap<String, Expression>();
            if (original instanceof J.MethodInvocation && (select = ((J.MethodInvocation)original).getSelect()) != null) {
                lookup.put("this", select);
            }
            List originalParameterNames = Objects.requireNonNull(original.getMethodType()).getParameterNames();
            for (int i = 0; i < originalParameterNames.size(); ++i) {
                String originalName = (String)originalParameterNames.get(i);
                Expression originalValue = (Expression)original.getArguments().get(i);
                lookup.put(originalName, originalValue);
            }
            ArrayList<Object> parameters = new ArrayList<Object>();
            Matcher matcher = TEMPLATE_IDENTIFIER.matcher(templateString);
            while (matcher.find()) {
                Expression o = (Expression)lookup.get(matcher.group(1));
                if (o == null) continue;
                parameters.add(o);
            }
            return parameters;
        }

        @ConstructorProperties(value={"replacement", "imports", "staticImports"})
        @Generated
        public InlineMeValues(String replacement, Set<String> imports, Set<String> staticImports) {
            this.replacement = replacement;
            this.imports = imports;
            this.staticImports = staticImports;
        }

        @Generated
        public Set<String> getImports() {
            return this.imports;
        }

        @Generated
        public Set<String> getStaticImports() {
            return this.staticImports;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InlineMeValues)) {
                return false;
            }
            InlineMeValues other = (InlineMeValues)o;
            String this$replacement = this.replacement;
            String other$replacement = other.replacement;
            if (this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement)) {
                return false;
            }
            Set<String> this$imports = this.getImports();
            Set<String> other$imports = other.getImports();
            if (this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports)) {
                return false;
            }
            Set<String> this$staticImports = this.getStaticImports();
            Set<String> other$staticImports = other.getStaticImports();
            return !(this$staticImports == null ? other$staticImports != null : !((Object)this$staticImports).equals(other$staticImports));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $replacement = this.replacement;
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            Set<String> $imports = this.getImports();
            result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
            Set<String> $staticImports = this.getStaticImports();
            result = result * 59 + ($staticImports == null ? 43 : ((Object)$staticImports).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "InlineMethodCalls.InlineMeValues(replacement=" + this.replacement + ", imports=" + this.getImports() + ", staticImports=" + this.getStaticImports() + ")";
        }
    }
}

