/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class SwitchCaseEnumGuardToLabel
extends Recipe {
    public String getDisplayName() {
        return "Use switch cases labels for enums";
    }

    public String getDescription() {
        return "Use switch case labels when a guard is checking equality with an enum.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not((TreeVisitor)new KotlinFileChecker()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Case visitCase(J.Case case_, ExecutionContext ctx) {
                Expression guardedEnum;
                J.Case visitedCase = super.visitCase(case_, (Object)ctx);
                J.VariableDeclarations.NamedVariable label = this.getCreatedLabelVariable(visitedCase);
                if (label == null) {
                    return visitedCase;
                }
                JavaType type = label.getType();
                if (type instanceof JavaType.Class && ((JavaType.Class)type).getKind() == JavaType.FullyQualified.Kind.Enum && (guardedEnum = this.getGuardedEnum(visitedCase, label)) != null) {
                    J modifiedBody = (J)this.enumReferencesToEnumValue(label.getSimpleName(), guardedEnum).visit((Tree)visitedCase.getBody(), (Object)ctx);
                    return visitedCase.withGuard(null).withCaseLabels(Collections.singletonList(guardedEnum.withPrefix(((J)visitedCase.getCaseLabels().get(0)).getPrefix()))).withBody(modifiedBody);
                }
                return visitedCase;
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.VariableDeclarations.NamedVariable getCreatedLabelVariable(J.Case case_) {
                if (case_.getCaseLabels().size() != 1 || !(case_.getCaseLabels().get(0) instanceof J.VariableDeclarations)) {
                    return null;
                }
                J.VariableDeclarations decl = (J.VariableDeclarations)case_.getCaseLabels().get(0);
                if (decl.getVariables().size() != 1) {
                    return null;
                }
                return (J.VariableDeclarations.NamedVariable)decl.getVariables().get(0);
            }

            private @Nullable Expression getGuardedEnum(J.Case case_, J.VariableDeclarations.NamedVariable label) {
                J.Binary binaryGuard;
                Expression guard = case_.getGuard();
                if (guard == null) {
                    return null;
                }
                Expression select = null;
                Expression equalTo = null;
                if (guard instanceof J.MethodInvocation) {
                    J.MethodInvocation methodGuard = (J.MethodInvocation)guard;
                    if ("equals".equals(methodGuard.getSimpleName()) && methodGuard.getArguments().size() == 1) {
                        select = methodGuard.getSelect();
                        equalTo = (Expression)methodGuard.getArguments().get(0);
                    }
                } else if (guard instanceof J.Binary && J.Binary.Type.Equal == (binaryGuard = (J.Binary)guard).getOperator()) {
                    select = binaryGuard.getLeft();
                    equalTo = binaryGuard.getRight();
                }
                if ((select instanceof J.FieldAccess || select instanceof J.Identifier) && equalTo instanceof J.Identifier && label.getName().getSimpleName().equals(((J.Identifier)equalTo).getSimpleName())) {
                    return select;
                }
                if ((equalTo instanceof J.FieldAccess || equalTo instanceof J.Identifier) && select instanceof J.Identifier && label.getName().getSimpleName().equals(((J.Identifier)select).getSimpleName())) {
                    return equalTo;
                }
                return null;
            }

            private JavaVisitor<ExecutionContext> enumReferencesToEnumValue(final String name, final Expression enumReference) {
                return new JavaVisitor<ExecutionContext>(){

                    public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
                        J.Identifier identifier = (J.Identifier)super.visitIdentifier(ident, (Object)ctx);
                        if (identifier.getSimpleName().equals(name) && TypeUtils.isOfType((JavaType)identifier.getType(), (JavaType)enumReference.getType())) {
                            return enumReference.withPrefix(identifier.getPrefix());
                        }
                        return identifier;
                    }
                };
            }
        });
    }

    @Generated
    public SwitchCaseEnumGuardToLabel() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "SwitchCaseEnumGuardToLabel()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchCaseEnumGuardToLabel)) {
            return false;
        }
        SwitchCaseEnumGuardToLabel other = (SwitchCaseEnumGuardToLabel)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof SwitchCaseEnumGuardToLabel;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

