/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.plexus;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class PlexusFileUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`PlexusFileUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.plexus.PlexusFileUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new DeleteDirectoryFileRecipe(), new DeleteDirectoryStringRecipe(), new FileExistsStringRecipe(), new GetFileRecipe()});
    }

    @NonNullApi
    public static class DeleteDirectoryFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.deleteDirectory(File)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.deleteDirectory(File directory)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", dir -> org.codehaus.plexus.util.FileUtils.deleteDirectory((File)dir)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", dir -> FileUtils.deleteDirectory((File)dir)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils deleteDirectory(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DeleteDirectoryStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.deleteDirectory(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.deleteDirectory(String directory)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", dir -> org.codehaus.plexus.util.FileUtils.deleteDirectory((String)dir)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", dir -> FileUtils.deleteDirectory((File)new File((String)dir))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils deleteDirectory(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FileExistsStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.fileExists(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.fileExists(String fileName)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", fileName -> org.codehaus.plexus.util.FileUtils.fileExists((String)fileName)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", fileName -> new File((String)fileName).exists()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils fileExists(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class GetFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.getFile(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Plexus `FileUtils.getFile(String fileName)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", fileName -> org.codehaus.plexus.util.FileUtils.getFile((String)fileName)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", fileName -> new File((String)fileName)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.codehaus.plexus.util.FileUtils getFile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

