/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;
import org.openrewrite.java.template.RecipeDescriptor;

public class ApacheCommonsFileUtils {

    @RecipeDescriptor(name="Replace `FileUtils.writeStringToFile(File, String)` with JDK provided API", description="Replace Apache Commons `FileUtils.writeStringToFile(File file, String data)` with JDK provided API.")
    public static class WriteStringToFile {
        void before(File a, String s) throws Exception {
            FileUtils.writeStringToFile((File)a, (String)s);
        }

        void after(File a, String s) throws Exception {
            Files.write(a.toPath(), s.getBytes(), new OpenOption[0]);
        }
    }

    @RecipeDescriptor(name="Replace `FileUtils.getFile(String...)` with JDK provided API", description="Replace Apache Commons `FileUtils.getFile(String... name)` with JDK provided API.")
    public static class GetFile {
        File before(String name) {
            return FileUtils.getFile((String[])new String[]{name});
        }

        File after(String name) {
            return new File(name);
        }
    }
}

