/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.maven.shared;

import java.util.Objects;
import org.apache.maven.shared.utils.StringUtils;
import org.openrewrite.java.migrate.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.template.Matches;
import org.openrewrite.java.template.RecipeDescriptor;

public class MavenSharedStringUtils {

    @RecipeDescriptor(name="Replace `StringUtils.upperCase(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.upperCase(String str)` with JDK provided API.")
    public static class Uppercase {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.upperCase((String)s);
        }

        String after(String s) {
            return s == null ? null : s.toUpperCase();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.trim(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.trim(String str)` with JDK provided API.")
    public static class Trim {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.trim((String)s);
        }

        String after(String s) {
            return s == null ? null : s.trim();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.strip(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.strip(String str)` with JDK provided API.")
    public static class Strip {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.strip((String)s);
        }

        String after(String s) {
            return s == null ? null : s.trim();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.split(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.split(String str)` with JDK provided API.")
    public static class Split {
        String[] before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.split((String)s);
        }

        String[] after(String s) {
            return s.split("\\s+");
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.reverse(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.reverse(String str)` with JDK provided API.")
    public static class Reverse {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.reverse((String)s);
        }

        String after(String s) {
            return s == null ? null : new StringBuffer(s).reverse().toString();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.replace(String, String, String)` with JDK provided API", description="Replace Maven Shared `StringUtils.replace(String text, String searchString, String replacement)` with JDK provided API.")
    public static class Replace {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) String search, @Matches(value=RepeatableArgumentMatcher.class) String replacement) {
            return StringUtils.replace((String)s, (String)search, (String)replacement);
        }

        String after(String s, String search, String replacement) {
            return s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace(search, replacement);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.lowerCase(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.lowerCase(String str)` with JDK provided API.")
    public static class Lowercase {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.lowerCase((String)s);
        }

        String after(String s) {
            return s == null ? null : s.toLowerCase();
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.equals(String, String)` with JDK provided API", description="Replace Maven Shared `StringUtils.equals(String str1, String str2)` with JDK provided API.")
    public static class Equals {
        boolean before(String s, String other) {
            return StringUtils.equals((String)s, (String)other);
        }

        boolean after(String s, String other) {
            return Objects.equals(s, other);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.equalsIgnoreCase(String, String)` with JDK provided API", description="Replace Maven Shared `StringUtils.equalsIgnoreCase(String str1, String str2)` with JDK provided API.")
    public static class EqualsIgnoreCase {
        boolean before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) String other) {
            return StringUtils.equalsIgnoreCase((String)s, (String)other);
        }

        boolean after(String s, String other) {
            return s == null ? other == null : s.equalsIgnoreCase(other);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.deleteWhitespace(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.deleteWhitespace(String str)` with JDK provided API.")
    public static class DeleteWhitespace {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.deleteWhitespace((String)s);
        }

        String after(String s) {
            return s.replaceAll("\\s+", "");
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.defaultString(Object, String)` with JDK provided API", description="Replace Maven Shared `StringUtils.defaultString(Object obj, String nullDefault)` with JDK provided API.")
    public static class DefaultStringFallback {
        String before(String s, String nullDefault) {
            return StringUtils.defaultString((Object)s, (String)nullDefault);
        }

        String after(String s, String nullDefault) {
            return Objects.toString(s, nullDefault);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.defaultString(Object)` with JDK provided API", description="Replace Maven Shared `StringUtils.defaultString(Object obj)` with JDK provided API.")
    public static class DefaultString {
        String before(String s) {
            return StringUtils.defaultString((Object)s);
        }

        String after(String s) {
            return Objects.toString(s, "");
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.capitalise(String)` with JDK provided API", description="Replace Maven Shared `StringUtils.capitalise(String str)` with JDK provided API.")
    public static class Capitalise {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.capitalise((String)s);
        }

        String after(String s) {
            return s == null || s.isEmpty() ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1);
        }
    }

    @RecipeDescriptor(name="Replace `StringUtils.abbreviate(String, int)` with JDK provided API", description="Replace Maven Shared `StringUtils.abbreviate(String str, int maxWidth)` with JDK provided API.")
    public static class Abbreviate {
        String before(@Matches(value=RepeatableArgumentMatcher.class) String s1, @Matches(value=RepeatableArgumentMatcher.class) int width) {
            return StringUtils.abbreviate((String)s1, (int)width);
        }

        String after(String s, int width) {
            return s.length() <= width ? s : s.substring(0, width - 3) + "...";
        }
    }
}

