/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.plexus;

import java.io.File;
import org.codehaus.plexus.util.FileUtils;
import org.openrewrite.java.template.RecipeDescriptor;

class PlexusFileUtils {
    PlexusFileUtils() {
    }

    @RecipeDescriptor(name="Replace `FileUtils.getFile(String)` with JDK internals", description="Replace Plexus `FileUtils.getFile(String fileName)` with JDK internals.")
    static class GetFile {
        GetFile() {
        }

        File before(String fileName) throws Exception {
            return FileUtils.getFile((String)fileName);
        }

        File after(String fileName) throws Exception {
            return new File(fileName);
        }
    }

    @RecipeDescriptor(name="Replace `FileUtils.fileExists(String)` with JDK internals", description="Replace Plexus `FileUtils.fileExists(String fileName)` with JDK internals.")
    static class FileExistsString {
        FileExistsString() {
        }

        boolean before(String fileName) throws Exception {
            return FileUtils.fileExists((String)fileName);
        }

        boolean after(String fileName) throws Exception {
            return new File(fileName).exists();
        }
    }

    @RecipeDescriptor(name="Replace `FileUtils.deleteDirectory(String)` with JDK internals", description="Replace Plexus `FileUtils.deleteDirectory(String directory)` with JDK internals.")
    static class DeleteDirectoryString {
        DeleteDirectoryString() {
        }

        void before(String dir) throws Exception {
            FileUtils.deleteDirectory((String)dir);
        }

        void after(String dir) throws Exception {
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(dir));
        }
    }

    @RecipeDescriptor(name="Replace `FileUtils.deleteDirectory(File)` with JDK internals", description="Replace Plexus `FileUtils.deleteDirectory(File directory)` with JDK internals.")
    static class DeleteDirectoryFile {
        DeleteDirectoryFile() {
        }

        void before(File dir) throws Exception {
            FileUtils.deleteDirectory((File)dir);
        }

        void after(File dir) throws Exception {
            org.apache.commons.io.FileUtils.deleteDirectory((File)dir);
        }
    }
}

