/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.table;

import java.beans.ConstructorProperties;
import org.openrewrite.Column;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class JavaVersionRow {
    @Column(displayName="Project name", description="The module name (useful especially for multi-module repositories).")
    private final String projectName;
    @Column(displayName="Source set name", description="The source set, e.g. `main` or `test`.")
    private final String sourceSetName;
    @Column(displayName="Created by", description="The JDK release that was used to compile the source file.")
    private final String createdBy;
    @Column(displayName="VM vendor", description="The vendor of the JVM that was used to compile the source file.")
    private final String vmVendor;
    @Column(displayName="Source compatibility", description="The source compatibility of the source file.")
    private final String sourceCompatibility;
    @Column(displayName="Major version source compatibility", description="The major version.")
    private final String majorVersionSourceCompatibility;
    @Column(displayName="Target compatibility", description="The target compatibility or `--release` version of the source file.")
    private final String targetCompatibility;

    @ConstructorProperties(value={"projectName", "sourceSetName", "createdBy", "vmVendor", "sourceCompatibility", "majorVersionSourceCompatibility", "targetCompatibility"})
    public JavaVersionRow(String projectName, String sourceSetName, String createdBy, String vmVendor, String sourceCompatibility, String majorVersionSourceCompatibility, String targetCompatibility) {
        this.projectName = projectName;
        this.sourceSetName = sourceSetName;
        this.createdBy = createdBy;
        this.vmVendor = vmVendor;
        this.sourceCompatibility = sourceCompatibility;
        this.majorVersionSourceCompatibility = majorVersionSourceCompatibility;
        this.targetCompatibility = targetCompatibility;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSourceSetName() {
        return this.sourceSetName;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public String getMajorVersionSourceCompatibility() {
        return this.majorVersionSourceCompatibility;
    }

    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaVersionRow)) {
            return false;
        }
        JavaVersionRow other = (JavaVersionRow)o;
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$sourceSetName = this.getSourceSetName();
        String other$sourceSetName = other.getSourceSetName();
        if (this$sourceSetName == null ? other$sourceSetName != null : !this$sourceSetName.equals(other$sourceSetName)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$vmVendor = this.getVmVendor();
        String other$vmVendor = other.getVmVendor();
        if (this$vmVendor == null ? other$vmVendor != null : !this$vmVendor.equals(other$vmVendor)) {
            return false;
        }
        String this$sourceCompatibility = this.getSourceCompatibility();
        String other$sourceCompatibility = other.getSourceCompatibility();
        if (this$sourceCompatibility == null ? other$sourceCompatibility != null : !this$sourceCompatibility.equals(other$sourceCompatibility)) {
            return false;
        }
        String this$majorVersionSourceCompatibility = this.getMajorVersionSourceCompatibility();
        String other$majorVersionSourceCompatibility = other.getMajorVersionSourceCompatibility();
        if (this$majorVersionSourceCompatibility == null ? other$majorVersionSourceCompatibility != null : !this$majorVersionSourceCompatibility.equals(other$majorVersionSourceCompatibility)) {
            return false;
        }
        String this$targetCompatibility = this.getTargetCompatibility();
        String other$targetCompatibility = other.getTargetCompatibility();
        return !(this$targetCompatibility == null ? other$targetCompatibility != null : !this$targetCompatibility.equals(other$targetCompatibility));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $sourceSetName = this.getSourceSetName();
        result = result * 59 + ($sourceSetName == null ? 43 : $sourceSetName.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $vmVendor = this.getVmVendor();
        result = result * 59 + ($vmVendor == null ? 43 : $vmVendor.hashCode());
        String $sourceCompatibility = this.getSourceCompatibility();
        result = result * 59 + ($sourceCompatibility == null ? 43 : $sourceCompatibility.hashCode());
        String $majorVersionSourceCompatibility = this.getMajorVersionSourceCompatibility();
        result = result * 59 + ($majorVersionSourceCompatibility == null ? 43 : $majorVersionSourceCompatibility.hashCode());
        String $targetCompatibility = this.getTargetCompatibility();
        result = result * 59 + ($targetCompatibility == null ? 43 : $targetCompatibility.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "JavaVersionRow(projectName=" + this.getProjectName() + ", sourceSetName=" + this.getSourceSetName() + ", createdBy=" + this.getCreatedBy() + ", vmVendor=" + this.getVmVendor() + ", sourceCompatibility=" + this.getSourceCompatibility() + ", majorVersionSourceCompatibility=" + this.getMajorVersionSourceCompatibility() + ", targetCompatibility=" + this.getTargetCompatibility() + ")";
    }
}

