/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class StringRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`StringRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.lang.StringRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new RedundantCallRecipe(), new IndexOfStringRecipe(), new IndexOfCharRecipe(), new UseEqualsIgnoreCaseRecipe()});
    }

    @NonNullApi
    public static class RedundantCallRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace redundant `String` method calls with self";
        }

        public String getDescription() {
            return "Replace redundant `substring(..)` and `toString()` method calls with the `String` self.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate start = Semantics.expression((JavaVisitor)this, (String)"start", string -> string.substring(0, string.length())).build();
                final JavaTemplate startAndEnd = Semantics.expression((JavaVisitor)this, (String)"startAndEnd", string -> string.substring(0)).build();
                final JavaTemplate toString = Semantics.expression((JavaVisitor)this, (String)"toString", string -> string.toString()).build();
                final JavaTemplate self = Semantics.expression((JavaVisitor)this, (String)"self", string -> string).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.start.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.self.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.startAndEnd.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.self.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.toString.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.self.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String substring(..)"), new UsesMethod("java.lang.String length(..)")}), new UsesMethod("java.lang.String substring(..)"), new UsesMethod("java.lang.String toString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IndexOfStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `String.indexOf(String, 0)` with `String.indexOf(String)`";
        }

        public String getDescription() {
            return "Replace `String.indexOf(String str, int fromIndex)` with `String.indexOf(String)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate indexOfZero = Semantics.expression((JavaVisitor)this, (String)"indexOfZero", (string, test) -> string.indexOf((String)test, 0)).build();
                final JavaTemplate indexOf = Semantics.expression((JavaVisitor)this, (String)"indexOf", (string, test) -> string.indexOf((String)test)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.indexOfZero.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.indexOf.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String indexOf(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IndexOfCharRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `String.indexOf(char, 0)` with `String.indexOf(char)`";
        }

        public String getDescription() {
            return "Replace `String.indexOf(char ch, int fromIndex)` with `String.indexOf(char)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate indexOfZero = Semantics.expression((JavaVisitor)this, (String)"indexOfZero", (string, test) -> string.indexOf(test.charValue(), 0)).build();
                final JavaTemplate indexOf = Semantics.expression((JavaVisitor)this, (String)"indexOf", (string, test) -> string.indexOf(test.charValue())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.indexOfZero.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.indexOf.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String indexOf(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class UseEqualsIgnoreCaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace lower and upper case `String` comparisons with `String.equalsIgnoreCase(String)`";
        }

        public String getDescription() {
            return "Replace `String` equality comparisons involving `.toLowerCase()` or `.toUpperCase()` with `String.equalsIgnoreCase(String anotherString)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate bothLowerCase = Semantics.expression((JavaVisitor)this, (String)"bothLowerCase", (string, test) -> string.toLowerCase().equals(test.toLowerCase())).build();
                final JavaTemplate bothUpperCase = Semantics.expression((JavaVisitor)this, (String)"bothUpperCase", (string, test) -> string.toUpperCase().equals(test.toUpperCase())).build();
                final JavaTemplate equalsIgnoreCase = Semantics.expression((JavaVisitor)this, (String)"equalsIgnoreCase", (string, test) -> string.equalsIgnoreCase((String)test)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.bothLowerCase.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.equalsIgnoreCase.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.bothUpperCase.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.equalsIgnoreCase.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String equals(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String toLowerCase(..)"), new UsesMethod("java.lang.String toUpperCase(..)")})}), (TreeVisitor)javaVisitor);
        }
    }
}

