/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class BeanValidationMessages
extends Recipe {
    private static final AnnotationMatcher JAVAX_MATCHER = new AnnotationMatcher("@javax.validation.constraints..*");

    public String getDisplayName() {
        return "Migrate Bean Validation messages";
    }

    public String getDescription() {
        return "Migrate `javax.validation.constraints` messages found in Java files to `jakarta.validation.constraints` equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("javax.validation.constraints..*", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext executionContext) {
                J.Annotation a = super.visitAnnotation(annotation, (Object)executionContext);
                if (!JAVAX_MATCHER.matches(a)) {
                    return a;
                }
                return a.withArguments(ListUtils.map((List)a.getArguments(), arg -> {
                    if (arg instanceof J.Assignment) {
                        J.Assignment as = (J.Assignment)arg;
                        if (as.getAssignment() instanceof J.Literal) {
                            return as.withAssignment((Expression)this.maybeReplaceLiteralValue((J.Literal)as.getAssignment()));
                        }
                    } else if (arg instanceof J.Literal) {
                        return this.maybeReplaceLiteralValue((J.Literal)arg);
                    }
                    return arg;
                }));
            }

            private J.Literal maybeReplaceLiteralValue(J.Literal arg) {
                String oldValue;
                if (arg.getType() == JavaType.Primitive.String && (oldValue = (String)arg.getValue()).contains("javax.")) {
                    String newValue = oldValue.replace("javax.", "jakarta.");
                    return arg.withValue((Object)newValue).withValueSource('\"' + newValue + '\"');
                }
                return arg;
            }
        });
    }
}

