/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ApacheCommonsFileUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ApacheCommonsFileUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.apache.commons.io.ApacheCommonsFileUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new GetFileRecipe(), new WriteStringToFileRecipe()});
    }

    @NonNullApi
    public static class GetFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.getFile(String...)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `FileUtils.getFile(String... name)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", name -> FileUtils.getFile((String[])new String[]{name})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", name -> new File((String)name)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.apache.commons.io.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.io.FileUtils getFile(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class WriteStringToFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `FileUtils.writeStringToFile(File, String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `FileUtils.writeStringToFile(File file, String data)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.statement((JavaVisitor)this, (String)"before", (a, s) -> FileUtils.writeStringToFile((File)a, (String)s)).build();
                final JavaTemplate after = Semantics.statement((JavaVisitor)this, (String)"after", (a, s) -> Files.write(a.toPath(), s.getBytes(), new OpenOption[0])).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.apache.commons.io.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.io.FileUtils writeStringToFile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

