/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaSetsNewLinkedHashSet
extends Recipe {
    private static final MethodMatcher NEW_LINKED_HASH_SET = new MethodMatcher("com.google.common.collect.Sets newLinkedHashSet()");
    private static final MethodMatcher NEW_LINKED_HASH_SET_ITERABLE = new MethodMatcher("com.google.common.collect.Sets newLinkedHashSet(java.lang.Iterable)");
    private static final MethodMatcher NEW_LINKED_HASH_SET_CAPACITY = new MethodMatcher("com.google.common.collect.Sets newLinkedHashSetWithExpectedSize(int)");

    public String getDisplayName() {
        return "Prefer `new LinkedHashSet<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(NEW_LINKED_HASH_SET), new UsesMethod(NEW_LINKED_HASH_SET_ITERABLE), new UsesMethod(NEW_LINKED_HASH_SET_CAPACITY)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_LINKED_HASH_SET.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    return JavaTemplate.builder((String)"new LinkedHashSet<>()").contextSensitive().imports(new String[]{"java.util.LinkedHashSet"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_LINKED_HASH_SET_ITERABLE.matches((MethodCall)method) && method.getArguments().size() == 1 && TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    return JavaTemplate.builder((String)"new LinkedHashSet<>(#{any(java.util.Collection)})").contextSensitive().imports(new String[]{"java.util.LinkedHashSet"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                if (NEW_LINKED_HASH_SET_CAPACITY.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.LinkedHashSet");
                    return JavaTemplate.builder((String)"new LinkedHashSet<>(#{any(int)})").contextSensitive().imports(new String[]{"java.util.LinkedHashSet"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

