/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.staticanalysis.RemoveMethodCallVisitor;

public class RemoveMethodInvocation
extends Recipe {
    @Option(displayName="Method Pattern", description="A method pattern for matching required method definition.", example="*..* hello(..)")
    @NonNull
    private String methodPattern;

    @JsonCreator
    public RemoveMethodInvocation(@JsonProperty(value="methodPattern") String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getDisplayName() {
        return "Remove methods calls";
    }

    public String getDescription() {
        return "Checks for a method patterns and removes the method call from the class.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveMethodCallVisitor(new MethodMatcher(this.methodPattern), (n, it) -> true);
    }
}

