/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.ChangeTagAttribute;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class BeanDiscovery
extends Recipe {
    private static final XPathMatcher BEANS_MATCHER = new XPathMatcher("/beans");
    private static final Pattern VERSION_PATTERN = Pattern.compile("_([^\\/\\.]+)\\.xsd");

    public String getDisplayName() {
        return "Behavior change to bean discovery in modules with `beans.xml` file with no version specified";
    }

    public String getDescription() {
        return "Alters beans with missing version attribute to include this attribute as well as the bean-discovery-mode=\"all\" attribute to maintain an explicit bean archive.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        XmlVisitor<ExecutionContext> xmlVisitor = new XmlVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (!BEANS_MATCHER.matches(this.getCursor()) || t.getAttributes().stream().map(Xml.Attribute::getKeyAsString).anyMatch("version"::equals)) {
                    return t;
                }
                boolean hasBeanDiscoveryMode = false;
                String idealVersion = null;
                for (Xml.Attribute attribute : t.getAttributes()) {
                    if (attribute.getKeyAsString().equals("bean-discovery-mode")) {
                        hasBeanDiscoveryMode = true;
                        continue;
                    }
                    if (!attribute.getKeyAsString().endsWith("schemaLocation")) continue;
                    String schemaLocation = attribute.getValueAsString();
                    idealVersion = this.parseVersion(schemaLocation);
                }
                if (hasBeanDiscoveryMode) {
                    TreeVisitor changeTagVisitor = new ChangeTagAttribute("beans", "bean-discovery-mode", "all", null).getVisitor();
                    t = (Xml.Tag)changeTagVisitor.visit((Tree)t, (Object)ctx, this.getCursor());
                } else {
                    t = this.addAttribute(t, "bean-discovery-mode", "all", ctx);
                }
                return this.addAttribute(t, "version", idealVersion != null ? idealVersion : "4.0", ctx);
            }

            private String parseVersion(String schemaLocation) {
                String version = null;
                Matcher m = VERSION_PATTERN.matcher(schemaLocation);
                if (m.find()) {
                    version = m.group(1).replace("_", ".");
                }
                return version;
            }

            private Xml.Tag addAttribute(Xml.Tag t, String name, String all, ExecutionContext ctx) {
                Xml.Attribute attribute = new Xml.Attribute(Tree.randomId(), "", Markers.EMPTY, new Xml.Ident(Tree.randomId(), "", Markers.EMPTY, name), "", new Xml.Attribute.Value(Tree.randomId(), "", Markers.EMPTY, Xml.Attribute.Value.Quote.Double, all));
                return t.withAttributes(ListUtils.concat((List)t.getAttributes(), (Object)((Xml.Attribute)this.autoFormat((Xml)attribute, ctx))));
            }
        };
        return Preconditions.check((TreeVisitor)new HasSourcePath("**/beans.xml"), (TreeVisitor)xmlVisitor);
    }

    @NonNull
    public String toString() {
        return "BeanDiscovery()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeanDiscovery)) {
            return false;
        }
        BeanDiscovery other = (BeanDiscovery)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof BeanDiscovery;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

