/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import java.util.List;
import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class UseEnumSetOf
extends Recipe {
    private static final MethodMatcher SET_OF = new MethodMatcher("java.util.Set of(..)", true);
    private static final String METHOD_TYPE = "java.util.EnumSet";

    public String getDisplayName() {
        return "Prefer `EnumSet of(..)`";
    }

    public String getDescription() {
        return "Prefer `EnumSet of(..)` instead of using `Set of(..)` when the arguments are enums in Java 5 or higher.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(SET_OF)}), (TreeVisitor)new UseEnumSetOfVisitor());
    }

    private static class UseEnumSetOfVisitor
    extends JavaVisitor<ExecutionContext> {
        private UseEnumSetOfVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
            Cursor parent;
            J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, (Object)ctx);
            if (SET_OF.matches((MethodCall)mi) && mi.getType() instanceof JavaType.Parameterized && !TypeUtils.isOfClassType((JavaType)mi.getType(), (String)UseEnumSetOf.METHOD_TYPE) && !((parent = this.getCursor().dropParentUntil(is -> is instanceof J.Assignment || is instanceof J.VariableDeclarations || is instanceof J.Block)).getValue() instanceof J.Block)) {
                JavaType type;
                JavaType javaType = type = parent.getValue() instanceof J.Assignment ? ((J.Assignment)parent.getValue()).getType() : ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)parent.getValue()).getVariables().get(0)).getType();
                if (this.isAssignmentSetOfEnum(type)) {
                    this.maybeAddImport(UseEnumSetOf.METHOD_TYPE);
                    List args = mi.getArguments();
                    if (this.isArrayParameter(args)) {
                        return mi;
                    }
                    if (args.get(0) instanceof J.Empty) {
                        JavaType firstTypeParameter = (JavaType)((JavaType.Parameterized)type).getTypeParameters().get(0);
                        JavaType.ShallowClass shallowClass = JavaType.ShallowClass.build((String)firstTypeParameter.toString());
                        return (J.MethodInvocation)JavaTemplate.builder((String)("EnumSet.noneOf(" + shallowClass.getClassName() + ".class)")).contextSensitive().imports(new String[]{UseEnumSetOf.METHOD_TYPE}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[0]);
                    }
                    StringJoiner setOf = new StringJoiner(", ", "EnumSet.of(", ")");
                    args.forEach(o -> setOf.add("#{any()}"));
                    return (J.MethodInvocation)JavaTemplate.builder((String)setOf.toString()).contextSensitive().imports(new String[]{UseEnumSetOf.METHOD_TYPE}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args.toArray());
                }
            }
            return mi;
        }

        private boolean isAssignmentSetOfEnum(@Nullable JavaType type) {
            JavaType.Parameterized parameterized;
            if (type instanceof JavaType.Parameterized && TypeUtils.isOfClassType((JavaType)(parameterized = (JavaType.Parameterized)type).getType(), (String)"java.util.Set")) {
                return ((JavaType.Parameterized)type).getTypeParameters().stream().filter(JavaType.Class.class::isInstance).map(JavaType.Class.class::cast).anyMatch(o -> o.getKind() == JavaType.FullyQualified.Kind.Enum);
            }
            return false;
        }

        private boolean isArrayParameter(List<Expression> args) {
            if (args.size() != 1) {
                return false;
            }
            JavaType type = args.get(0).getType();
            return TypeUtils.asArray((JavaType)type) != null;
        }
    }
}

