/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.java.migrate.joda.JodaTimeScanner;
import org.openrewrite.java.migrate.joda.JodaTimeVisitor;
import org.openrewrite.java.migrate.joda.ScopeAwareVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

public class JodaTimeRecipe
extends ScanningRecipe<Accumulator> {
    public String getDisplayName() {
        return "Migrate Joda-Time to Java time";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Joda Time.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public JodaTimeScanner getScanner(Accumulator acc) {
        return new JodaTimeScanner(acc);
    }

    public JodaTimeVisitor getVisitor(Accumulator acc) {
        return new JodaTimeVisitor(acc, true, new LinkedList<ScopeAwareVisitor.VariablesInScope>());
    }

    public static class Accumulator {
        private final Set<J.VariableDeclarations.NamedVariable> unsafeVars = new HashSet<J.VariableDeclarations.NamedVariable>();
        private final VarTable varTable = new VarTable();

        @Generated
        public Set<J.VariableDeclarations.NamedVariable> getUnsafeVars() {
            return this.unsafeVars;
        }

        @Generated
        public VarTable getVarTable() {
            return this.varTable;
        }
    }

    static class VarTable {
        private final Map<JavaType, List<J.VariableDeclarations.NamedVariable>> vars = new HashMap<JavaType, List<J.VariableDeclarations.NamedVariable>>();

        VarTable() {
        }

        public void addVars(J.MethodDeclaration methodDeclaration) {
            JavaType.Method type = methodDeclaration.getMethodType();
            assert (type != null);
            methodDeclaration.getParameters().forEach(arg_0 -> this.lambda$addVars$1((JavaType)type, arg_0));
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.VariableDeclarations.NamedVariable getVarByName(@Nullable JavaType declaringType, String varName) {
            return this.vars.getOrDefault(declaringType, Collections.emptyList()).stream().filter(v -> v.getSimpleName().equals(varName)).findFirst().orElse(null);
        }

        private /* synthetic */ void lambda$addVars$1(JavaType type, Statement p) {
            if (!(p instanceof J.VariableDeclarations)) {
                return;
            }
            J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)p).getVariables().get(0);
            this.vars.computeIfAbsent(type, k -> new ArrayList()).add(namedVariable);
        }
    }
}

