/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NullMarked
public class ReplaceMathRandomWithThreadLocalRandomRecipe
extends Recipe {
    public String getDisplayName() {
        return "Replace `java.lang.Math random()` with `ThreadLocalRandom nextDouble()`";
    }

    public String getDescription() {
        return "Replace `java.lang.Math random()` with `ThreadLocalRandom nextDouble()` to reduce contention.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            final JavaTemplate javaMathRandom = JavaTemplate.builder((String)"Math.random()").build();
            final JavaTemplate threadLocalRandomNextDouble = JavaTemplate.builder((String)"java.util.concurrent.ThreadLocalRandom.current().nextDouble()").build();

            public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher = this.javaMathRandom.matcher(this.getCursor());
                if (matcher.find()) {
                    return this.embed(this.threadLocalRandomNextDouble.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Math random(..)", true), (TreeVisitor)javaVisitor);
    }
}

