/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.joda.templates.AbstractInstantTemplates;
import org.openrewrite.java.migrate.joda.templates.DateTimeFormatTemplates;
import org.openrewrite.java.migrate.joda.templates.DateTimeTemplates;
import org.openrewrite.java.migrate.joda.templates.DurationTemplates;
import org.openrewrite.java.migrate.joda.templates.MethodTemplate;
import org.openrewrite.java.migrate.joda.templates.TimeClassMap;
import org.openrewrite.java.migrate.joda.templates.TimeClassNames;
import org.openrewrite.java.migrate.joda.templates.TimeZoneTemplates;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JodaTimeVisitor
extends JavaVisitor<ExecutionContext> {
    private final MethodMatcher anyNewDateTime = new MethodMatcher("org.joda.time.DateTime<constructor>(..)");
    private final MethodMatcher anyDateTime = new MethodMatcher("org.joda.time.DateTime *(..)");
    private final MethodMatcher anyBaseDateTime = new MethodMatcher("org.joda.time.base.BaseDateTime *(..)");
    private final MethodMatcher zoneFor = new MethodMatcher("org.joda.time.DateTimeZone for*(..)");
    private final MethodMatcher anyTimeFormatter = new MethodMatcher("org.joda.time.format.DateTimeFormat *(..)");
    private final MethodMatcher anyNewDuration = new MethodMatcher("org.joda.time.Duration<constructor>(..)");
    private final MethodMatcher anyDuration = new MethodMatcher("org.joda.time.Duration *(..)");
    private final MethodMatcher anyAbstractInstant = new MethodMatcher("org.joda.time.base.AbstractInstant *(..)");
    private boolean scanMode;

    public JodaTimeVisitor(boolean scanMode) {
        this.scanMode = scanMode;
    }

    public JodaTimeVisitor() {
        this(false);
    }

    @NonNull
    public J visitCompilationUnit(@NonNull J.CompilationUnit cu, @NonNull ExecutionContext ctx) {
        if (cu == null) {
            throw new NullPointerException("cu is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.maybeRemoveImport("org.joda.time.DateTime");
        this.maybeRemoveImport("org.joda.time.DateTimeZone");
        this.maybeRemoveImport("org.joda.time.format.DateTimeFormat");
        this.maybeRemoveImport("org.joda.time.Duration");
        this.maybeRemoveImport("org.joda.time.base.AbstractInstant");
        this.maybeRemoveImport("java.util.Locale");
        this.maybeAddImport("java.time.ZonedDateTime");
        this.maybeAddImport("java.time.ZoneOffset");
        this.maybeAddImport("java.time.ZoneId");
        this.maybeAddImport("java.time.Instant");
        this.maybeAddImport("java.time.format.DateTimeFormatter");
        this.maybeAddImport("java.time.format.FormatStyle");
        this.maybeAddImport("java.time.Duration");
        this.maybeAddImport("java.time.LocalDate");
        this.maybeAddImport("java.time.LocalTime");
        this.maybeAddImport("java.time.temporal.IsoFields");
        this.maybeAddImport("java.time.temporal.ChronoField");
        this.maybeAddImport("java.util.Date");
        return super.visitCompilationUnit(cu, (Object)ctx);
    }

    @NonNull
    public J visitVariable(@NonNull J.VariableDeclarations.NamedVariable variable, @NonNull ExecutionContext ctx) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (variable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return variable;
        }
        return super.visitVariable(variable, (Object)ctx);
    }

    @NonNull
    public J visitAssignment(@NonNull J.Assignment assignment, @NonNull ExecutionContext ctx) {
        if (assignment == null) {
            throw new NullPointerException("assignment is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.Assignment a = (J.Assignment)super.visitAssignment(assignment, (Object)ctx);
        return a.withType(a.getVariable().getType());
    }

    @NonNull
    public J visitNewClass(@NonNull J.NewClass newClass, @NonNull ExecutionContext ctx) {
        if (newClass == null) {
            throw new NullPointerException("newClass is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        MethodCall updated = (MethodCall)super.visitNewClass(newClass, (Object)ctx);
        if (this.hasJodaType(updated.getArguments())) {
            return newClass;
        }
        if (this.anyNewDateTime.matches((MethodCall)newClass)) {
            return this.applyTemplate((MethodCall)newClass, updated, DateTimeTemplates.getTemplates()).orElse((J)newClass);
        }
        if (this.anyNewDuration.matches((MethodCall)newClass)) {
            return this.applyTemplate((MethodCall)newClass, updated, DurationTemplates.getTemplates()).orElse((J)newClass);
        }
        if (this.areArgumentsAssignable(updated)) {
            return updated;
        }
        return newClass;
    }

    @NonNull
    public J visitMethodInvocation(@NonNull J.MethodInvocation method, @NonNull ExecutionContext ctx) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
        if (this.hasJodaType(m.getArguments()) || this.isJodaVarRef(m.getSelect())) {
            return method;
        }
        if (this.zoneFor.matches((MethodCall)method)) {
            return this.applyTemplate((MethodCall)method, (MethodCall)m, TimeZoneTemplates.getTemplates()).orElse((J)method);
        }
        if (this.anyDateTime.matches((MethodCall)method) || this.anyBaseDateTime.matches((MethodCall)method)) {
            return this.applyTemplate((MethodCall)method, (MethodCall)m, DateTimeTemplates.getTemplates()).orElse((J)method);
        }
        if (this.anyAbstractInstant.matches((MethodCall)method)) {
            return this.applyTemplate((MethodCall)method, (MethodCall)m, AbstractInstantTemplates.getTemplates()).orElse((J)method);
        }
        if (this.anyTimeFormatter.matches((MethodCall)method)) {
            return this.applyTemplate((MethodCall)method, (MethodCall)m, DateTimeFormatTemplates.getTemplates()).orElse((J)method);
        }
        if (this.anyDuration.matches((MethodCall)method)) {
            return this.applyTemplate((MethodCall)method, (MethodCall)m, DurationTemplates.getTemplates()).orElse((J)method);
        }
        if (method.getSelect() != null && method.getSelect().getType() != null && method.getSelect().getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return method;
        }
        if (this.areArgumentsAssignable((MethodCall)m)) {
            return m;
        }
        return method;
    }

    @NonNull
    public J visitFieldAccess(@NonNull J.FieldAccess fieldAccess, @NonNull ExecutionContext ctx) {
        if (fieldAccess == null) {
            throw new NullPointerException("fieldAccess is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.FieldAccess f = (J.FieldAccess)super.visitFieldAccess(fieldAccess, (Object)ctx);
        if (TypeUtils.isOfClassType((JavaType)f.getType(), (String)"org.joda.time.DateTimeZone") && f.getSimpleName().equals("UTC")) {
            return JavaTemplate.builder((String)"ZoneOffset.UTC").imports(new String[]{"java.time.ZoneOffset"}).build().apply(this.updateCursor((Tree)f), f.getCoordinates().replace(), new Object[0]);
        }
        return f;
    }

    @NonNull
    public J visitIdentifier(@NonNull J.Identifier ident, @NonNull ExecutionContext ctx) {
        if (ident == null) {
            throw new NullPointerException("ident is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!this.isJodaVarRef((Expression)ident) || !this.scanMode) {
            return super.visitIdentifier(ident, (Object)ctx);
        }
        if (!(ident.getType() instanceof JavaType.Class)) {
            return ident;
        }
        JavaType.Class jodaType = (JavaType.Class)ident.getType();
        JavaType.Class fqType = TimeClassMap.getJavaTimeType(jodaType.getFullyQualifiedName());
        return ident.withType((JavaType)fqType).withFieldType(ident.getFieldType().withType((JavaType)fqType));
    }

    private boolean hasJodaType(List<Expression> exprs) {
        for (Expression expr : exprs) {
            JavaType exprType = expr.getType();
            if (exprType == null || !exprType.isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) continue;
            return true;
        }
        return false;
    }

    private Optional<J> applyTemplate(MethodCall original, MethodCall updated, List<MethodTemplate> templates) {
        for (MethodTemplate template : templates) {
            if (!template.getMatcher().matches(original)) continue;
            Expression[] args = template.getTemplateArgsFunc().apply(updated);
            if (args.length == 0) {
                return Optional.of(template.getTemplate().apply(this.updateCursor((Tree)updated), updated.getCoordinates().replace(), new Object[0]));
            }
            return Optional.of(template.getTemplate().apply(this.updateCursor((Tree)updated), updated.getCoordinates().replace(), (Object[])args));
        }
        return Optional.empty();
    }

    private boolean areArgumentsAssignable(MethodCall m) {
        if (m.getMethodType() == null || this.getArgumentsCount(m) != m.getMethodType().getParameterTypes().size()) {
            return false;
        }
        if (this.getArgumentsCount(m) == 0) {
            return true;
        }
        for (int i = 0; i < m.getArguments().size(); ++i) {
            if (TypeUtils.isAssignableTo((JavaType)((JavaType)m.getMethodType().getParameterTypes().get(i)), (JavaType)((Expression)m.getArguments().get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    private int getArgumentsCount(MethodCall m) {
        if (m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Empty) {
            return 0;
        }
        return m.getArguments().size();
    }

    private boolean isJodaVarRef(@Nullable Expression expr) {
        if (expr == null || expr.getType() == null || !expr.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return false;
        }
        if (expr instanceof J.FieldAccess) {
            return ((J.FieldAccess)expr).getName().getFieldType() != null;
        }
        if (expr instanceof J.Identifier) {
            return ((J.Identifier)expr).getFieldType() != null;
        }
        return false;
    }
}

