/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import fj.data.Option;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.analysis.dataflow.analysis.SinkFlowSummary;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.joda.JodaTimeFlowSpec;
import org.openrewrite.java.migrate.joda.JodaTimeVisitor;
import org.openrewrite.java.migrate.joda.SafeCheckMarker;
import org.openrewrite.java.migrate.joda.templates.TimeClassNames;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;

public class JodaTimeScanner
extends JavaIsoVisitor<ExecutionContext> {
    private final Set<J.VariableDeclarations.NamedVariable> unsafeVars = new HashSet<J.VariableDeclarations.NamedVariable>();
    private final LinkedList<VariablesInScope> scopes = new LinkedList();
    private final Map<J.VariableDeclarations.NamedVariable, Set<J.VariableDeclarations.NamedVariable>> varDependencies = new HashMap<J.VariableDeclarations.NamedVariable, Set<J.VariableDeclarations.NamedVariable>>();

    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
        cu = super.visitCompilationUnit(cu, (Object)ctx);
        HashSet<J.VariableDeclarations.NamedVariable> allReachable = new HashSet<J.VariableDeclarations.NamedVariable>();
        for (J.VariableDeclarations.NamedVariable var : this.unsafeVars) {
            this.dfs(var, allReachable);
        }
        this.unsafeVars.addAll(allReachable);
        return cu;
    }

    public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
        this.scopes.push(new VariablesInScope(this.getCursor()));
        J.Block b = super.visitBlock(block, (Object)ctx);
        this.scopes.pop();
        return b;
    }

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
        assert (!this.scopes.isEmpty());
        this.scopes.peek().variables.add(variable);
        if (!variable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return variable;
        }
        if (!this.isLocalVar(variable)) {
            this.unsafeVars.add(variable);
            return variable;
        }
        if (!(variable = super.visitVariable(variable, (Object)ctx)).getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN) || variable.getInitializer() == null) {
            return variable;
        }
        List<Expression> sinks = this.findSinks(variable.getInitializer());
        assert (!this.scopes.isEmpty());
        Cursor currentScope = this.scopes.peek().getScope();
        J.Block block = (J.Block)currentScope.getValue();
        new AddSafeCheckMarker(sinks).visit((Tree)block, ctx, currentScope.getParent());
        this.processMarkersOnExpression(sinks, variable);
        return variable;
    }

    public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
        Expression var = assignment.getVariable();
        if (!this.isJodaExpr(var) || !(var instanceof J.Identifier)) {
            return assignment;
        }
        J.Identifier ident = (J.Identifier)var;
        Optional<J.VariableDeclarations.NamedVariable> mayBeVar = this.findVarInScope(ident.getSimpleName());
        if (!mayBeVar.isPresent()) {
            return assignment;
        }
        J.VariableDeclarations.NamedVariable variable = mayBeVar.get();
        Cursor varScope = this.findScope(variable);
        List<Expression> sinks = this.findSinks(assignment.getAssignment());
        new AddSafeCheckMarker(sinks).visit((Tree)varScope.getValue(), ctx, varScope.getParent());
        this.processMarkersOnExpression(sinks, variable);
        return assignment;
    }

    private void processMarkersOnExpression(List<Expression> expressions, J.VariableDeclarations.NamedVariable var) {
        for (Expression expr : expressions) {
            Optional mayBeMarker = expr.getMarkers().findFirst(SafeCheckMarker.class);
            if (!mayBeMarker.isPresent()) continue;
            SafeCheckMarker marker = (SafeCheckMarker)mayBeMarker.get();
            if (!marker.isSafe()) {
                this.unsafeVars.add(var);
            }
            if (marker.getReferences().isEmpty()) continue;
            this.varDependencies.compute(var, (k, v) -> v == null ? new HashSet() : v).addAll(marker.getReferences());
            for (J.VariableDeclarations.NamedVariable ref : marker.getReferences()) {
                this.varDependencies.compute(ref, (k, v) -> v == null ? new HashSet() : v).add(var);
            }
        }
    }

    private boolean isJodaExpr(Expression expression) {
        return expression.getType() != null && expression.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN);
    }

    private List<Expression> findSinks(Expression expr) {
        Cursor cursor = new Cursor(this.getCursor(), (Object)expr);
        Option mayBeSinks = Dataflow.startingAt((Cursor)cursor).findSinks((DataFlowSpec)new JodaTimeFlowSpec());
        if (mayBeSinks.isNone()) {
            return Collections.emptyList();
        }
        return ((SinkFlowSummary)mayBeSinks.some()).getExpressionSinks();
    }

    private boolean isLocalVar(J.VariableDeclarations.NamedVariable variable) {
        if (!(variable.getVariableType().getOwner() instanceof JavaType.Method)) {
            return false;
        }
        J j = (J)this.getCursor().dropParentUntil(t -> t instanceof J.Block || t instanceof J.MethodDeclaration).getValue();
        return j instanceof J.Block;
    }

    private Optional<J.VariableDeclarations.NamedVariable> findVarInScope(String varName) {
        for (VariablesInScope scope : this.scopes) {
            for (J.VariableDeclarations.NamedVariable var : scope.variables) {
                if (!var.getSimpleName().equals(varName)) continue;
                return Optional.of(var);
            }
        }
        return Optional.empty();
    }

    private Cursor findScope(J.VariableDeclarations.NamedVariable variable) {
        for (VariablesInScope scope : this.scopes) {
            if (!scope.variables.contains(variable)) continue;
            return scope.scope;
        }
        return null;
    }

    private void dfs(J.VariableDeclarations.NamedVariable root, Set<J.VariableDeclarations.NamedVariable> visited) {
        if (visited.contains(root)) {
            return;
        }
        visited.add(root);
        for (J.VariableDeclarations.NamedVariable dep : this.varDependencies.getOrDefault(root, Collections.emptySet())) {
            this.dfs(dep, visited);
        }
    }

    @Generated
    public Set<J.VariableDeclarations.NamedVariable> getUnsafeVars() {
        return this.unsafeVars;
    }

    private static final class VariablesInScope {
        private final Cursor scope;
        private final Set<J.VariableDeclarations.NamedVariable> variables;

        public VariablesInScope(Cursor scope) {
            this.scope = scope;
            this.variables = new HashSet<J.VariableDeclarations.NamedVariable>();
        }

        @Generated
        public Cursor getScope() {
            return this.scope;
        }

        @Generated
        public Set<J.VariableDeclarations.NamedVariable> getVariables() {
            return this.variables;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariablesInScope)) {
                return false;
            }
            VariablesInScope other = (VariablesInScope)o;
            Cursor this$scope = this.getScope();
            Cursor other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            Set<J.VariableDeclarations.NamedVariable> this$variables = this.getVariables();
            Set<J.VariableDeclarations.NamedVariable> other$variables = other.getVariables();
            return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Cursor $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            Set<J.VariableDeclarations.NamedVariable> $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
            return result;
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public String toString() {
            return "JodaTimeScanner.VariablesInScope(scope=" + this.getScope() + ", variables=" + this.getVariables() + ")";
        }
    }

    private class AddSafeCheckMarker
    extends JavaIsoVisitor<ExecutionContext> {
        @NonNull
        private List<Expression> expressions;

        public Expression visitExpression(Expression expression, ExecutionContext ctx) {
            int index = this.expressions.indexOf(expression);
            if (index == -1) {
                return super.visitExpression(expression, (Object)ctx);
            }
            Expression withMarker = (Expression)expression.withMarkers(expression.getMarkers().addIfAbsent((Marker)this.getMarker(expression, ctx)));
            this.expressions.set(index, withMarker);
            return withMarker;
        }

        private SafeCheckMarker getMarker(Expression expr, ExecutionContext ctx) {
            Optional mayBeMarker = expr.getMarkers().findFirst(SafeCheckMarker.class);
            if (mayBeMarker.isPresent()) {
                return (SafeCheckMarker)mayBeMarker.get();
            }
            Cursor boundary = this.findBoundaryCursorForJodaExpr();
            boolean isSafe = true;
            if (boundary.getParentTreeCursor().getValue() instanceof J.Return) {
                isSafe = false;
            }
            Expression boundaryExpr = (Expression)boundary.getValue();
            J j = (J)new JodaTimeVisitor(true).visit((Tree)boundaryExpr, ctx, boundary.getParentTreeCursor());
            HashSet<J.VariableDeclarations.NamedVariable> referencedVars = new HashSet<J.VariableDeclarations.NamedVariable>();
            new FindVarReferences().visit((Tree)expr, referencedVars, this.getCursor().getParentTreeCursor());
            AtomicBoolean hasJodaType = new AtomicBoolean();
            new HasJodaType().visit((Tree)j, hasJodaType);
            isSafe = isSafe && !hasJodaType.get() && !referencedVars.contains(null);
            referencedVars.remove(null);
            return new SafeCheckMarker(UUID.randomUUID(), isSafe, referencedVars);
        }

        private Cursor findBoundaryCursorForJodaExpr() {
            Cursor cursor = this.getCursor();
            while (cursor.getValue() instanceof Expression && JodaTimeScanner.this.isJodaExpr((Expression)cursor.getValue())) {
                Cursor parent = cursor.getParentTreeCursor();
                if (parent.getValue() instanceof J && !(parent.getValue() instanceof Expression)) {
                    return cursor;
                }
                cursor = parent;
            }
            return cursor;
        }

        @ConstructorProperties(value={"expressions"})
        @Generated
        public AddSafeCheckMarker(List<Expression> expressions) {
            if (expressions == null) {
                throw new NullPointerException("expressions is marked non-null but is null");
            }
            this.expressions = expressions;
        }
    }

    private static class HasJodaType
    extends JavaIsoVisitor<AtomicBoolean> {
        private HasJodaType() {
        }

        public Expression visitExpression(Expression expression, AtomicBoolean hasJodaType) {
            if (hasJodaType.get()) {
                return expression;
            }
            if (expression.getType() != null && expression.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
                hasJodaType.set(true);
            }
            return super.visitExpression(expression, (Object)hasJodaType);
        }
    }

    private class FindVarReferences
    extends JavaIsoVisitor<Set<J.VariableDeclarations.NamedVariable>> {
        private FindVarReferences() {
        }

        public J.Identifier visitIdentifier(J.Identifier ident, Set<J.VariableDeclarations.NamedVariable> vars) {
            if (!JodaTimeScanner.this.isJodaExpr((Expression)ident) || ident.getFieldType() == null) {
                return ident;
            }
            if (ident.getFieldType().getOwner() instanceof JavaType.Class) {
                vars.add(null);
            }
            JodaTimeScanner.this.findVarInScope(ident.getSimpleName()).ifPresent(vars::add);
            return ident;
        }
    }
}

