/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.J;

public class RemoveIllegalSemicolons
extends Recipe {
    public String getDisplayName() {
        return "Remove illegal semicolons";
    }

    public String getDescription() {
        return "Remove semicolons after package declarations and imports, no longer accepted in Java 21 as of [JDK-8027682](https://bugs.openjdk.org/browse/JDK-8027682).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(21), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Import visitImport(J.Import _import, ExecutionContext ctx) {
                J.Import im = super.visitImport(_import, (Object)ctx);
                if (im.getPrefix().getWhitespace().contains(";")) {
                    im = im.withPrefix(im.getPrefix().withWhitespace(im.getPrefix().getWhitespace().replaceAll("\\s*;(\\R*)\\s*", "$1")));
                }
                return im;
            }
        });
    }
}

