/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public final class HttpSessionInvalidate
extends Recipe {
    public String getDisplayName() {
        return "Use HttpServletRequest `logout` method for programmatic security logout in Servlet 3.0";
    }

    public String getDescription() {
        return "Do not rely on HttpSession `invalidate` method for programmatic security logout. Add the HttpServletRequest `logout` method which was introduced in Java EE 6 as part of the Servlet 3.0 specification.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher invalidateMethodMatcher = new MethodMatcher("javax.servlet.http.HttpSession invalidate()", false);
        final TypeMatcher httpServletRequestTypeMatcher = new TypeMatcher("javax.servlet.http.HttpServletRequest");
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(invalidateMethodMatcher), new UsesType("javax.servlet.http.HttpServletRequest", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (invalidateMethodMatcher.matches((MethodCall)method)) {
                    J.MethodDeclaration parentMethod = (J.MethodDeclaration)this.getCursor().dropParentUntil(parent -> parent instanceof J.MethodDeclaration).getValue();
                    Integer servletReqParamIndex = this.getServletRequestIndex(parentMethod);
                    if (servletReqParamIndex == null) {
                        return method;
                    }
                    J.VariableDeclarations httpServletRequestDeclaration = (J.VariableDeclarations)parentMethod.getParameters().get(servletReqParamIndex);
                    JavaTemplate logoutTemplate = JavaTemplate.builder((String)"#{any(javax.servlet.http.HttpServletRequest)}.logout()").imports(new String[]{"javax.servlet.http.HttpServletRequest"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"javax.servlet-3.0"})).build();
                    method = (J.MethodInvocation)logoutTemplate.apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{httpServletRequestDeclaration.getVariables().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            @Nullable
            private Integer getServletRequestIndex(J.MethodDeclaration parentMethod) {
                List params = parentMethod.getMethodType().getParameterTypes();
                for (int i = 0; i < params.size(); ++i) {
                    if (!httpServletRequestTypeMatcher.matches((JavaType)params.get(i))) continue;
                    return i;
                }
                return null;
            }
        });
    }

    @Generated
    public HttpSessionInvalidate() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "HttpSessionInvalidate()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSessionInvalidate)) {
            return false;
        }
        HttpSessionInvalidate other = (HttpSessionInvalidate)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HttpSessionInvalidate;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

