/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.ChangeDependency;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.ChangeManagedDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.UpgradeDependencyVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class AddJaxbRuntime
extends ScanningRecipe<AtomicBoolean> {
    private static final String JACKSON_GROUP = "com.fasterxml.jackson.module";
    private static final String JACKSON_JAXB_ARTIFACT = "jackson-module-jaxb-annotations";
    private static final String JAKARTA_API_GROUP = "jakarta.xml.bind";
    private static final String JAKARTA_API_ARTIFACT = "jakarta.xml.bind-api";
    private static final String SUN_JAXB_RUNTIME_GROUP = "com.sun.xml.bind";
    private static final String SUN_JAXB_RUNTIME_ARTIFACT = "jaxb-impl";
    private static final String GLASSFISH_JAXB_RUNTIME_GROUP = "org.glassfish.jaxb";
    private static final String GLASSFISH_JAXB_RUNTIME_ARTIFACT = "jaxb-runtime";
    @Option(displayName="JAXB run-time", description="Which implementation of the JAXB run-time that will be added to maven projects that have transitive dependencies on the JAXB API", valid={"glassfish", "sun"}, example="glassfish")
    private final String runtime;

    public String getDisplayName() {
        return "Use latest JAXB API and runtime for Jakarta EE 8";
    }

    public String getDescription() {
        return "Update build files to use the latest JAXB runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater. The recipe will add a JAXB run-time, in Gradle `compileOnly`+`testImplementation` and Maven `provided` scope, to any project that has a transitive dependency on the JAXB API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("javax", "jakarta", "javaee", "jaxb", "glassfish", "java11"));
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Nullable
            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (acc.get()) {
                    return (J)tree;
                }
                J t = new UsesType("javax.xml.bind..*", Boolean.valueOf(true)).visit(tree, (Object)ctx);
                if (t != tree) {
                    acc.set(true);
                }
                return (J)tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final TreeVisitor<?, ExecutionContext> gradleVisitor = Preconditions.check((TreeVisitor)new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

                public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                    G.CompilationUnit g = cu;
                    if ("sun".equals(AddJaxbRuntime.this.runtime)) {
                        if (this.getAfterVisit().isEmpty()) {
                            this.doAfterVisit(new org.openrewrite.gradle.UpgradeDependencyVersion(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor());
                        }
                        g = (G.CompilationUnit)new ChangeDependency(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, null).getVisitor().visitNonNull((Tree)g, (Object)ctx);
                    } else {
                        if (this.getAfterVisit().isEmpty()) {
                            this.doAfterVisit(new org.openrewrite.gradle.UpgradeDependencyVersion(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor());
                        }
                        g = (G.CompilationUnit)new ChangeDependency(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, null).getVisitor().visitNonNull((Tree)g, (Object)ctx);
                    }
                    if (!acc.get()) {
                        return g;
                    }
                    Optional maybeGp = g.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGp.isPresent()) {
                        return g;
                    }
                    GradleProject gp = (GradleProject)maybeGp.get();
                    GradleDependencyConfiguration rc = gp.getConfiguration("runtimeClasspath");
                    if (rc == null || rc.findResolvedDependency(AddJaxbRuntime.JAKARTA_API_GROUP, AddJaxbRuntime.JAKARTA_API_ARTIFACT) == null || rc.findResolvedDependency(AddJaxbRuntime.JACKSON_GROUP, AddJaxbRuntime.JACKSON_JAXB_ARTIFACT) != null) {
                        return g;
                    }
                    String groupId = AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP;
                    String artifactId = AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT;
                    String version = "2.3.x";
                    if ("sun".equals(AddJaxbRuntime.this.runtime)) {
                        groupId = AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP;
                        artifactId = AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT;
                    }
                    if (rc.findResolvedDependency(groupId, artifactId) == null) {
                        g = (G.CompilationUnit)new AddDependencyVisitor(groupId, artifactId, version, null, "runtimeOnly", null, null, null, null).visitNonNull((Tree)g, (Object)ctx);
                    }
                    return g;
                }
            });
            final TreeVisitor<?, ExecutionContext> mavenVisitor = new MavenIsoVisitor<ExecutionContext>(){

                public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                    Xml.Document d = super.visitDocument(document, (Object)ctx);
                    d = "sun".equals(AddJaxbRuntime.this.runtime) ? AddJaxbRuntime.this.jaxbDependencySwap(ctx, d, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT) : AddJaxbRuntime.this.jaxbDependencySwap(ctx, d, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT);
                    return this.maybeAddRuntimeDependency(d, ctx);
                }

                private Xml.Document maybeAddRuntimeDependency(Xml.Document d, ExecutionContext ctx) {
                    if (!acc.get()) {
                        return d;
                    }
                    MavenResolutionResult mavenModel = this.getResolutionResult();
                    if (!mavenModel.findDependencies(AddJaxbRuntime.JACKSON_GROUP, AddJaxbRuntime.JACKSON_JAXB_ARTIFACT, Scope.Runtime).isEmpty() || mavenModel.findDependencies(AddJaxbRuntime.JAKARTA_API_GROUP, AddJaxbRuntime.JAKARTA_API_ARTIFACT, Scope.Runtime).isEmpty()) {
                        return d;
                    }
                    String groupId = AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP;
                    String artifactId = AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT;
                    String version = "2.3.x";
                    if ("sun".equals(AddJaxbRuntime.this.runtime)) {
                        groupId = AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP;
                        artifactId = AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT;
                    }
                    d = this.getResolutionResult().findDependencies(groupId, artifactId, Scope.Runtime).isEmpty() ? (Xml.Document)new org.openrewrite.maven.AddDependencyVisitor(groupId, artifactId, version, null, Scope.Runtime.name().toLowerCase(), null, null, null, null, null).visitNonNull((Tree)d, (Object)ctx) : (Xml.Document)new UpgradeDependencyVersion(groupId, artifactId, version, null, Boolean.valueOf(false), null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
                    return d;
                }
            };

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t = this.gradleVisitor.visit(tree, (Object)ctx);
                return this.mavenVisitor.visit(t, (Object)ctx);
            }
        };
    }

    private Xml.Document jaxbDependencySwap(ExecutionContext ctx, Xml.Document d, String sunJaxbRuntimeGroup, String sunJaxbRuntimeArtifact, String glassfishJaxbRuntimeGroup, String glassfishJaxbRuntimeArtifact) {
        d = (Xml.Document)new UpgradeDependencyVersion(sunJaxbRuntimeGroup, sunJaxbRuntimeArtifact, "2.3.x", null, null, null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
        d = (Xml.Document)new ChangeDependencyGroupIdAndArtifactId(glassfishJaxbRuntimeGroup, glassfishJaxbRuntimeArtifact, sunJaxbRuntimeGroup, sunJaxbRuntimeArtifact, "2.3.x", null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
        d = (Xml.Document)new ChangeManagedDependencyGroupIdAndArtifactId(glassfishJaxbRuntimeGroup, glassfishJaxbRuntimeArtifact, sunJaxbRuntimeGroup, sunJaxbRuntimeArtifact, "2.3.x").getVisitor().visitNonNull((Tree)d, (Object)ctx);
        return d;
    }

    @ConstructorProperties(value={"runtime"})
    @Generated
    public AddJaxbRuntime(String runtime) {
        this.runtime = runtime;
    }

    @Generated
    public String getRuntime() {
        return this.runtime;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddJaxbRuntime(runtime=" + this.getRuntime() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJaxbRuntime)) {
            return false;
        }
        AddJaxbRuntime other = (AddJaxbRuntime)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$runtime = this.getRuntime();
        String other$runtime = other.getRuntime();
        return !(this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddJaxbRuntime;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
        return result;
    }
}

