/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ReplaceStreamCollectWithToList
extends Recipe {
    private static final MethodMatcher STREAM_COLLECT = new MethodMatcher("java.util.stream.Stream collect(java.util.stream.Collector)");
    private static final MethodMatcher COLLECT_TO_UNMODIFIABLE_LIST = new MethodMatcher("java.util.stream.Collectors toUnmodifiableList()");
    private static final MethodMatcher COLLECT_TO_LIST = new MethodMatcher("java.util.stream.Collectors toList()");
    @Option(displayName="Convert mutable `Collectors.toList()` to immutable", description="Also replace `Stream.collect(Collectors.toList())` with `Stream.toList()`. *BEWARE*: Attempts to modify the returned list, result in an `UnsupportedOperationException`!", required=false)
    @Nullable
    private final Boolean convertToList;

    public String getDisplayName() {
        return "Replace `Stream.collect(Collectors.toUnmodifiableList())` with `Stream.toList()`";
    }

    public String getDescription() {
        return "Replace `Stream.collect(Collectors.toUnmodifiableList())` with Java 16+ `Stream.toList()`. Also replaces `Stream.collect(Collectors.toList())` if `convertToList` is set to `true`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Collections.singletonList("RSPEC-S6204"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(16), new UsesMethod(STREAM_COLLECT), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(COLLECT_TO_UNMODIFIABLE_LIST), new UsesMethod(COLLECT_TO_LIST)})}), (TreeVisitor)new ReplaceCollectorToListVisitor(Boolean.TRUE.equals(this.convertToList)));
    }

    @ConstructorProperties(value={"convertToList"})
    public ReplaceStreamCollectWithToList(@Nullable Boolean convertToList) {
        this.convertToList = convertToList;
    }

    @Nullable
    public Boolean getConvertToList() {
        return this.convertToList;
    }

    @NonNull
    public String toString() {
        return "ReplaceStreamCollectWithToList(convertToList=" + this.getConvertToList() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStreamCollectWithToList)) {
            return false;
        }
        ReplaceStreamCollectWithToList other = (ReplaceStreamCollectWithToList)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$convertToList = this.getConvertToList();
        Boolean other$convertToList = other.getConvertToList();
        return !(this$convertToList == null ? other$convertToList != null : !((Object)this$convertToList).equals(other$convertToList));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceStreamCollectWithToList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $convertToList = this.getConvertToList();
        result = result * 59 + ($convertToList == null ? 43 : ((Object)$convertToList).hashCode());
        return result;
    }

    private static final class ReplaceCollectorToListVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final JavaTemplate template = JavaTemplate.builder((String)"#{any(java.util.stream.Stream)}.toList()").build();
        private final boolean convertToList;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation result = super.visitMethodInvocation(method, (Object)ctx);
            if (!STREAM_COLLECT.matches((MethodCall)method)) {
                return result;
            }
            Expression command = (Expression)method.getArguments().get(0);
            if (COLLECT_TO_UNMODIFIABLE_LIST.matches(command) || this.convertToList && COLLECT_TO_LIST.matches(command)) {
                this.maybeRemoveImport("java.util.stream.Collectors");
                J.MethodInvocation toList = (J.MethodInvocation)template.apply(this.updateCursor((Tree)result), result.getCoordinates().replace(), new Object[]{result.getSelect()});
                return toList.getPadding().withSelect(result.getPadding().getSelect());
            }
            return result;
        }

        @ConstructorProperties(value={"convertToList"})
        public ReplaceCollectorToListVisitor(boolean convertToList) {
            this.convertToList = convertToList;
        }
    }
}

