/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.migrate.table.JavaVersionTable;
import org.openrewrite.java.tree.J;

public final class FindJavaVersion
extends Recipe {
    private final transient JavaVersionTable table = new JavaVersionTable(this);
    private static Set<JavaVersion> seen = new HashSet<JavaVersion>();

    public String getDisplayName() {
        return "Find Java versions in use";
    }

    public String getDescription() {
        return "Finds Java versions in use.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeJv = cu.getMarkers().findFirst(JavaVersion.class);
                if (!maybeJv.isPresent()) {
                    return cu;
                }
                JavaVersion jv = (JavaVersion)maybeJv.get();
                if (!seen.add(jv)) {
                    return cu;
                }
                FindJavaVersion.this.table.insertRow(ctx, new JavaVersionTable.Row(jv.getSourceCompatibility(), jv.getTargetCompatibility()));
                return cu;
            }
        };
    }

    public JavaVersionTable getTable() {
        return this.table;
    }

    @NonNull
    public String toString() {
        return "FindJavaVersion(table=" + (Object)((Object)this.getTable()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindJavaVersion)) {
            return false;
        }
        FindJavaVersion other = (FindJavaVersion)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindJavaVersion;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

