/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.UpdateJavaCompatibility;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;
    private static final List<String> JAVA_VERSION_XPATHS = Arrays.asList("/project/properties/java.version", "/project/properties/jdk.version", "/project/properties/javaVersion", "/project/properties/jdkVersion", "/project/properties/maven.compiler.source", "/project/properties/maven.compiler.target", "/project/properties/maven.compiler.release", "/project/properties/release.version", "/project/build//plugins/plugin[artifactId='maven-compiler-plugin']/configuration/source", "/project/build//plugins/plugin[artifactId='maven-compiler-plugin']/configuration/target", "/project/build//plugins/plugin[artifactId='maven-compiler-plugin']/configuration/release");
    private static final List<XPathMatcher> JAVA_VERSION_XPATH_MATCHERS = JAVA_VERSION_XPATHS.stream().map(XPathMatcher::new).collect(Collectors.toList());

    public String getDisplayName() {
        return "Upgrade Java version";
    }

    public String getDescription() {
        return "Upgrade build plugin configuration to use the specified Java version. This recipe changes `java.toolchain.languageVersion` in `build.gradle(.kts)` of gradle projects, or maven-compiler-plugin target version and related settings. Will not downgrade if the version is newer than the specified version.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String newVersion = this.version.toString();
        final HashMap updatedMarkers = new HashMap();
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile source = (SourceFile)tree;
                if (source instanceof G.CompilationUnit && new IsBuildGradle().visit((Tree)source, (Object)ctx) != source) {
                    source = (SourceFile)new UpdateJavaCompatibility(UpgradeJavaVersion.this.version, null, null, Boolean.valueOf(false), null).getVisitor().visitNonNull((Tree)source, (Object)ctx);
                } else if (source instanceof Xml.Document) {
                    source = (SourceFile)new MavenUpdateJavaVersionVisitor().visitNonNull((Tree)source, ctx);
                }
                Optional maybeJavaVersion = source.getMarkers().findFirst(JavaVersion.class);
                if (maybeJavaVersion.isPresent() && ((JavaVersion)maybeJavaVersion.get()).getMajorVersion() < UpgradeJavaVersion.this.version) {
                    source = (SourceFile)source.withMarkers(source.getMarkers().setByType((Marker)updatedMarkers.computeIfAbsent((JavaVersion)maybeJavaVersion.get(), m -> m.withSourceCompatibility(newVersion).withTargetCompatibility(newVersion))));
                }
                return source;
            }
        };
    }

    @ConstructorProperties(value={"version"})
    public UpgradeJavaVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "UpgradeJavaVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeJavaVersion)) {
            return false;
        }
        UpgradeJavaVersion other = (UpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }

    private class MavenUpdateJavaVersionVisitor
    extends MavenVisitor<ExecutionContext> {
        private MavenUpdateJavaVersionVisitor() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            tag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
            if (JAVA_VERSION_XPATH_MATCHERS.stream().anyMatch(matcher -> matcher.matches(this.getCursor()))) {
                Optional maybeVersion = tag.getValue().flatMap(value -> {
                    try {
                        return Optional.of(Float.valueOf(Float.parseFloat(value)));
                    }
                    catch (NumberFormatException e) {
                        return Optional.empty();
                    }
                });
                if (!maybeVersion.isPresent()) {
                    return tag;
                }
                float currentVersion = ((Float)maybeVersion.get()).floatValue();
                if (currentVersion >= (float)UpgradeJavaVersion.this.version.intValue()) {
                    return tag;
                }
                return tag.withValue(String.valueOf(UpgradeJavaVersion.this.version));
            }
            return tag;
        }
    }
}

