/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.sql;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class MigrateDriverManagerSetLogStream
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.sql.DriverManager setLogStream(java.io.PrintStream)");

    public String getDisplayName() {
        return "Use `DriverManager#setLogWriter(java.io.PrintWriter)`";
    }

    public String getDescription() {
        return "Use `DriverManager#setLogWriter(java.io.PrintWriter)` instead of the deprecated `DriverManager#setLogStream(java.io.PrintStream)` in Java 1.2 or higher.";
    }

    public Set<String> getTags() {
        return Collections.singleton("deprecated");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches(m)) {
                    m = m.withName(m.getName().withSimpleName("setLogWriter"));
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"new java.io.PrintWriter(#{any(java.io.PrintStream)})").build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0)});
                }
                return m;
            }
        });
    }
}

