/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class NoGuavaOptionalToJavaUtil
extends Recipe {
    static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.base.Optional toJavaUtil()");

    public String getDisplayName() {
        return "Remove `com.google.common.base.Optional#toJavaUtil()`";
    }

    public String getDescription() {
        return "Remove calls to `com.google.common.base.Optional#toJavaUtil()`.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-4738", "guava"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new ReplaceToJavaUtilVisitor());
    }

    private static class ReplaceToJavaUtilVisitor
    extends JavaVisitor<ExecutionContext> {
        private ReplaceToJavaUtilVisitor() {
        }

        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeAddImport("java.util.Optional");
            this.maybeRemoveImport("com.google.common.base.Optional");
            return c;
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi;
            J j = super.visitMethodInvocation(method, (Object)ctx);
            if (j instanceof J.MethodInvocation && METHOD_MATCHER.matches(mi = (J.MethodInvocation)j)) {
                return mi.getSelect();
            }
            return j;
        }
    }
}

