/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaImmutableMapOf
extends Recipe {
    private static final MethodMatcher IMMUTABLE_MAP_MATCHER = new MethodMatcher("com.google.common.collect.ImmutableMap of(..)");

    public String getDisplayName() {
        return "Prefer `Map.of(..)` in Java 9 or higher";
    }

    public String getDescription() {
        return "Replaces `ImmutableMap.of(..)` if the returned type is immediately down-cast.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-4738", "guava"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(false))});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                method = super.visitMethodInvocation(method, (Object)ctx);
                if (IMMUTABLE_MAP_MATCHER.matches(method) && this.isParentTypeDownCast()) {
                    this.maybeRemoveImport("com.google.common.collect.ImmutableMap");
                    this.maybeAddImport("java.util.Map");
                    String template = method.getArguments().stream().map(arg -> {
                        if (arg.getType() instanceof JavaType.Primitive) {
                            String type = "";
                            if (JavaType.Primitive.Boolean == arg.getType()) {
                                type = "Boolean";
                            } else if (JavaType.Primitive.Byte == arg.getType()) {
                                type = "Byte";
                            } else if (JavaType.Primitive.Char == arg.getType()) {
                                type = "Character";
                            } else if (JavaType.Primitive.Double == arg.getType()) {
                                type = "Double";
                            } else if (JavaType.Primitive.Float == arg.getType()) {
                                type = "Float";
                            } else if (JavaType.Primitive.Int == arg.getType()) {
                                type = "Integer";
                            } else if (JavaType.Primitive.Long == arg.getType()) {
                                type = "Long";
                            } else if (JavaType.Primitive.Short == arg.getType()) {
                                type = "Short";
                            } else if (JavaType.Primitive.String == arg.getType()) {
                                type = "String";
                            }
                            return TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)("java.lang." + type)));
                        }
                        return TypeUtils.asFullyQualified((JavaType)arg.getType());
                    }).filter(Objects::nonNull).map(type -> "#{any(" + type.getFullyQualifiedName() + ")}").collect(Collectors.joining(",", "Map.of(", ")"));
                    return (J.MethodInvocation)JavaTemplate.builder((String)template).contextSensitive().imports(new String[]{"java.util.Map"}).build().apply(this.updateCursor((Tree)method), method.getCoordinates().replace(), method.getArguments().get(0) instanceof J.Empty ? new Object[]{} : method.getArguments().toArray());
                }
                return method;
            }

            private boolean isParentTypeDownCast() {
                J parent = (J)this.getCursor().dropParentUntil(J.class::isInstance).getValue();
                boolean isParentTypeDownCast = false;
                if (parent instanceof J.VariableDeclarations.NamedVariable) {
                    isParentTypeDownCast = this.isParentTypeMatched(((J.VariableDeclarations.NamedVariable)parent).getType());
                } else if (parent instanceof J.Assignment) {
                    J.Assignment a = (J.Assignment)parent;
                    if (a.getVariable() instanceof J.Identifier && ((J.Identifier)a.getVariable()).getFieldType() != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(((J.Identifier)a.getVariable()).getFieldType().getType());
                    } else if (a.getVariable() instanceof J.FieldAccess) {
                        isParentTypeDownCast = this.isParentTypeMatched(a.getVariable().getType());
                    }
                } else if (parent instanceof J.Return) {
                    TypeTree returnType;
                    J j = (J)this.getCursor().dropParentUntil(is -> is instanceof J.MethodDeclaration || is instanceof J.CompilationUnit).getValue();
                    if (j instanceof J.MethodDeclaration && (returnType = ((J.MethodDeclaration)j).getReturnTypeExpression()) != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(returnType.getType());
                    }
                } else if (parent instanceof J.MethodInvocation) {
                    J.MethodInvocation m = (J.MethodInvocation)parent;
                    int index = 0;
                    for (Expression argument : m.getArguments()) {
                        if (IMMUTABLE_MAP_MATCHER.matches(argument)) break;
                        ++index;
                    }
                    if (m.getMethodType() != null) {
                        isParentTypeDownCast = this.isParentTypeMatched((JavaType)m.getMethodType().getParameterTypes().get(index));
                    }
                } else if (parent instanceof J.NewClass) {
                    J.NewClass c = (J.NewClass)parent;
                    int index = 0;
                    if (c.getConstructorType() != null) {
                        for (Expression argument : c.getArguments()) {
                            if (IMMUTABLE_MAP_MATCHER.matches(argument)) break;
                            ++index;
                        }
                        if (c.getConstructorType() != null) {
                            isParentTypeDownCast = this.isParentTypeMatched((JavaType)c.getConstructorType().getParameterTypes().get(index));
                        }
                    }
                } else if (parent instanceof J.NewArray) {
                    J.NewArray a = (J.NewArray)parent;
                    JavaType arrayType = a.getType();
                    while (arrayType instanceof JavaType.Array) {
                        arrayType = ((JavaType.Array)arrayType).getElemType();
                    }
                    isParentTypeDownCast = this.isParentTypeMatched(arrayType);
                }
                return isParentTypeDownCast;
            }

            private boolean isParentTypeMatched(@Nullable JavaType type) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)type);
                return TypeUtils.isOfClassType((JavaType)fq, (String)"java.util.Map") || TypeUtils.isOfClassType((JavaType)fq, (String)"java.lang.Object") || TypeUtils.isOfClassType((JavaType)fq, (String)"com.google.common.collect.ImmutableMap");
            }
        });
    }
}

