/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaMapsNewLinkedHashMap
extends Recipe {
    private static final MethodMatcher NEW_LINKED_HASH_MAP = new MethodMatcher("com.google.common.collect.Maps newLinkedHashMap()");
    private static final MethodMatcher NEW_LINKED_HASH_MAP_WITH_MAP = new MethodMatcher("com.google.common.collect.Maps newLinkedHashMap(java.util.Map)");
    private static final MethodMatcher NEW_LINKED_HASH_MAP_CAPACITY = new MethodMatcher("com.google.common.collect.Maps newLinkedHashMapWithExpectedSize(int)");

    public String getDisplayName() {
        return "Prefer `new LinkedHashMap<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_HASH_MAP));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_HASH_MAP_WITH_MAP));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_HASH_MAP_CAPACITY));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newLinkedHashMap = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedHashMap<>()").imports(new String[]{"java.util.LinkedHashMap"}).build();
            private final JavaTemplate newLinkedHashMapWithMap = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedHashMap<>(#{any(java.util.Map)})").imports(new String[]{"java.util.LinkedHashMap"}).build();
            private final JavaTemplate newLinkedHashMapCapacity = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedHashMap<>(#{any(int)})").imports(new String[]{"java.util.LinkedHashMap"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_LINKED_HASH_MAP.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.LinkedHashMap");
                    return method.withTemplate((SourceTemplate)this.newLinkedHashMap, method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_LINKED_HASH_MAP_WITH_MAP.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.LinkedHashMap");
                    return method.withTemplate((SourceTemplate)this.newLinkedHashMapWithMap, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                if (NEW_LINKED_HASH_MAP_CAPACITY.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.LinkedHashMap");
                    return method.withTemplate((SourceTemplate)this.newLinkedHashMapCapacity, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }
}

