/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaListsNewLinkedList
extends Recipe {
    private static final MethodMatcher NEW_LINKED_LIST = new MethodMatcher("com.google.common.collect.Lists newLinkedList()");
    private static final MethodMatcher NEW_LINKED_LIST_ITERABLE = new MethodMatcher("com.google.common.collect.Lists newLinkedList(java.lang.Iterable)");

    public String getDisplayName() {
        return "Prefer `new LinkedList<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_LIST));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_LINKED_LIST_ITERABLE));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newLinkedList = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedList<>()").imports(new String[]{"java.util.LinkedList"}).build();
            private final JavaTemplate newLinkedListCollection = JavaTemplate.builder(() -> (this).getCursor(), (String)"new LinkedList<>(#{any(java.util.Collection)})").imports(new String[]{"java.util.LinkedList"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_LINKED_LIST.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.LinkedList");
                    return method.withTemplate((SourceTemplate)this.newLinkedList, method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_LINKED_LIST_ITERABLE.matches(method) && method.getArguments().size() == 1 && TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.LinkedList");
                    return method.withTemplate((SourceTemplate)this.newLinkedListCollection, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }
}

