/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.codec;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.template.SourceTemplate;

public class ApacheBase64ToJavaBase64
extends Recipe {
    public String getDisplayName() {
        return "Prefer `java.util.Base64`";
    }

    public String getDescription() {
        return "Prefer the Java standard library's `java.util.Base64` over third-party usage of apache's `apache.commons.codec.binary.Base64`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("apache", "commons"));
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.apache.commons.codec.binary.Base64", Boolean.valueOf(false));
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher apacheEncodeToString = new MethodMatcher("org.apache.commons.codec.binary.Base64 encodeBase64String(byte[])");
            private final MethodMatcher apacheEncode64 = new MethodMatcher("org.apache.commons.codec.binary.Base64 encodeBase64(byte[])");
            private final MethodMatcher apacheDecode = new MethodMatcher("org.apache.commons.codec.binary.Base64 decodeBase64(..)");
            private final MethodMatcher apacheEncode64UrlSafe = new MethodMatcher("org.apache.commons.codec.binary.Base64 encodeBase64URLSafe(..)");
            private final MethodMatcher apacheEncode64UrlSafeString = new MethodMatcher("org.apache.commons.codec.binary.Base64 encodeBase64URLSafeString(..)");

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                String templatePrefix = null;
                if (this.apacheEncodeToString.matches(mi)) {
                    String argType = ((Expression)mi.getArguments().get(0)).getType() instanceof JavaType.Array ? "#{anyArray()}" : "#{any(String)}";
                    templatePrefix = "Base64.getEncoder().encodeToString(" + argType + ")";
                } else if (this.apacheEncode64.matches(mi)) {
                    templatePrefix = "Base64.getEncoder().encode(#{anyArray()})";
                } else if (this.apacheDecode.matches(mi)) {
                    templatePrefix = "Base64.getDecoder().decode(#{any(String)})";
                } else if (this.apacheEncode64UrlSafe.matches(mi)) {
                    templatePrefix = "Base64.getUrlEncoder().withoutPadding().encode(#{anyArray()})";
                } else if (this.apacheEncode64UrlSafeString.matches(mi)) {
                    templatePrefix = "Base64.getUrlEncoder().withoutPadding().encodeToString(#{anyArray()})";
                }
                if (templatePrefix != null) {
                    JavaTemplate t = JavaTemplate.builder(() -> (this).getCursor(), (String)templatePrefix).imports(new String[]{"java.util.Base64"}).build();
                    this.maybeRemoveImport("org.apache.commons.codec.binary.Base64");
                    this.maybeAddImport("java.util.Base64");
                    mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)t, mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)});
                }
                return mi;
            }
        };
    }
}

