/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.metrics;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class SimplifyMicrometerMeterTags
extends Recipe {
    private static final MethodMatcher COUNTER_TAGS = new MethodMatcher("io.micrometer.core.instrument.Counter.Builder tags(String[])");

    public String getDisplayName() {
        return "Simplify [Micrometer](https://micrometer.io) meter tags";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Use the simplest method to add new tags.";
    }

    public Set<String> getTags() {
        return Collections.singleton("micrometer");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)executionContext);
                if (COUNTER_TAGS.matches(m)) {
                    if (m.getArguments().get(0) instanceof J.NewArray) {
                        J.NewArray arr = (J.NewArray)m.getArguments().get(0);
                        if (arr.getInitializer() != null && arr.getInitializer().size() > 1) {
                            m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any(String)}, #{any(String)}").build(), m.getCoordinates().replaceArguments(), new Object[]{arr.getInitializer().get(0), arr.getInitializer().get(1)});
                        }
                    } else {
                        m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any()}[0], #{any()}[1]").build(), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0), m.getArguments().get(0)});
                    }
                    m = m.withName(m.getName().withSimpleName("tag"));
                }
                return m;
            }
        };
    }
}

